/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.style;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Render;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TokenTypes;

import java.text.ParseException;
import java.util.Vector;

/**
 * Υ쥯ɽ饹Ǥ
 * <p>
 * ߡ¹Ҷ쥯饹ܥ쥯°쥯
 * ݡȤƤޤ
 * </p>
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
class Selector {
    private static final String RESOURCE = "net.hizlab.kagetaka.addin.style.Resources";

    private static final int FALSE  = 0;
    private static final int TRUE   = 1;
    private static final int PSEUDO = 2;

    /** б륹 */
    Style style;

    private Operator operator;
    private Operator lastOperator;

    /**
     * 쥯ޤ
     *
     * @param  value 쥯
     *
     * @throws ParseException եޥåȤξ
     */
    Selector(String value)
            throws ParseException {
        if (value == null) {
            return;
        }
        int length = value.length();
        if (length == 0) {
            return;
        }

        int  p = 0;
        char c = value.charAt(0);
        // ɤФƬФ򤹤
        while (c == ' ') {
            if (++p >= length) {
                return;
            }
            c = value.charAt(p);
        }

        Operator o     = new Operator(null);
        char     type  = 0;
        String   s;
        int      start = 0;

        READ:
        for (p = 0; p <= length; p++) {
            if (p < length) {
                c = value.charAt(p);
            } else {
                c = ' ';                            // ʼ
            }
            switch (c) {
            case '\\':
                if (p + 1 < length) {
                    p++;
                }
                break;
            case ',':
            case ' ':
            case '>':
            case '+':
            case '[':
            case '.':
            case '#':
            case ':':
                // Ĺ 0 ξ̵IE Mozilla Ĺ 0 ʸǧ롦
                if (start == p) {
                    switch (type) {
                    case '.':
                    case '#':
                    case ':':
                        //### ERROR ٹĹ 0 ʤΤ̵뤷ޤ
                        continue READ;
                    default: // AVOID
                    }
                }
                switch (type) {
                case 0:   // ̾
                    if (start == p) {
                        o.targetType = Operator.ALL;
                    } else {
                        s = value.substring(start, p);
                        if (s.compareTo("*") == 0) {
                            o.targetType = Operator.ALL;
                        } else if ((o.targetType = TokenTypes.getType(CSSParser.unescape(s, 0, s.length(), false) + "_START")) == TokenTypes.UNKNOWN) {
                            throw new ParseException(Resource.getMessage(RESOURCE, "selector.error.unknowntarget", new String[]{s}), p);
                        }
                    }
                    break;
                case '[': // °쥯
                    //### TODO °쥯
                    o.addAttribute(null, null, 0);
                    break;
                case '.': // 饹쥯
                    o.addClass(CSSParser.unescape(value, start, p, false));
                    break;
                case '#': // ե쥯
                    o.addId(CSSParser.unescape(value, start, p, false));
                    break;
                case ':': // 饹
                    s = CSSParser.unescape(value, start, p, false);
                    if (s.compareTo("first-child") == 0) { o.pseudoClasses |= Render.PSEUDO_FIRST_CHILD; } else
                    if (s.compareTo("link"       ) == 0) { o.pseudoClasses |= Render.PSEUDO_LINK       ; } else
                    if (s.compareTo("visited"    ) == 0) { o.pseudoClasses |= Render.PSEUDO_VISITED    ; } else
                    if (s.compareTo("hover"      ) == 0) { o.pseudoClasses |= Render.PSEUDO_HOVER      ; } else
                    if (s.compareTo("active"     ) == 0) { o.pseudoClasses |= Render.PSEUDO_ACTIVE     ; } else
                    if (s.compareTo("focus"      ) == 0) { o.pseudoClasses |= Render.PSEUDO_FOCUS      ; } else
                    if (s.startsWith("lang(") && s.endsWith(")")) {
                        o.pseudoClasses |= Render.PSEUDO_LANG;
                        o.pseudoLang = s.substring(5, s.length() - 1);
                    } else
                    if (s.compareTo("first-line"  ) == 0) { o.pseudoElements |= Render.PSEUDO_FIRST_LINE  ; } else
                    if (s.compareTo("first-letter") == 0) { o.pseudoElements |= Render.PSEUDO_FIRST_LETTER; } else
                    if (s.compareTo("before"      ) == 0) { o.pseudoElements |= Render.PSEUDO_BEFORE      ; } else
                    if (s.compareTo("after"       ) == 0) { o.pseudoElements |= Render.PSEUDO_AFTER       ; } else
                    if (s.compareTo("marker"      ) == 0) { o.pseudoElements |= Render.PSEUDO_MARKER      ; } else
                    {
                        throw new ParseException(Resource.getMessage(RESOURCE, "selector.error.invalidpseudo", new String[]{value, s}), p);
                    }
                    break;
                default: // AVOID
                }

                type  = c;
                start = p + 1;
                switch (c) {
                case '[':
                    //### TODO ] ޤǤɤФ
                case '.':
                case '#':
                case ':':
                    continue READ;
                default: // AVOID
                }

                /////// 쥯ʣ

                // ƬζɤФ
                while (c == ' ') {
                    if (++p >= length) {
                        break READ;
                    }
                    c = value.charAt(p);
                }
                type = c;
                // ҸζɤФ
                switch (type) {
                case ',':
                case '>':
                case '+':
                    do {
                        if (++p >= length) {
                            throw new ParseException(Resource.getMessage(RESOURCE, "selector.error.nosimpleselector", new String[]{value, String.valueOf(type)}), p);
                        }
                        c = value.charAt(p);
                    } while (c == ' ');
                default: // AVOID
                }
                // 쥯
                switch (type) {
                case ',':
                    if (operator == null) {
                        lastOperator = operator = o;
                    } else {
                        lastOperator = lastOperator.nextOperator = o;
                    }
                    o = new Operator(null);
                    type = 0;
                    continue READ;
                case '>': o.combinator = Operator.PARENT     ; break;
                case '+': o.combinator = Operator.PREDECESSOR; break;
                default : o.combinator = Operator.ANCESTOR   ; break;
                }
                o = new Operator(o);
                type = 0;
            default: // AVOID
            }
        }
        if (operator == null) {
            lastOperator = operator = o;
        } else {
            lastOperator = lastOperator.nextOperator = o;
        }
    }

    /**
     * Υ쥯ȡȹפ뤫Ĵ٤ޤ
     *
     * @param  token  ȡ
     * @param  status ơ
     *
     * @return פ <code>true</code>
     *         פʤ <code>false</code>
     */
    boolean isMatch(StartToken token, Status status) {
        if (operator == null) {
            return true;
        }

        Operator o   = operator;
        boolean  ret = false;
        do {
            switch (o.isMatch(token)) {
            case TRUE:
                ret = true;
                break;
            case PSEUDO:
                o.hasPseudo = true;
                if (status.pseudoStyles == null) {
                    status.pseudoStyles = new Vector();
                }
                status.pseudoStyles.addElement(style);
                break;
            default: // AVOID
            }
        } while ((o = o.nextOperator) != null);

        return ret;
    }

    /**
     * Υ쥯饹Ǥȹפ뤫Ĵ٤ޤ
     * {@link #isMatch(StartToken, Status)} ˤ롢ȡȤιפ
     * ƤΤ˸ƤӽФޤ
     *
     * @param  pseudo ׵᤹뵼饹Ǥμ
     *
     * @return פ <code>true</code>
     *         ʳξ <code>false</code>
     */
    boolean isMatch(int pseudo) {
        Operator o = operator;
        do {
            if (o.hasPseudo && o.isMatch(pseudo)) {
                return true;
            }
        } while ((o = o.nextOperator) != null);

        return false;
    }

    /**
     * Υ쥯ʸɽ֤ޤ
     *
     * @return ʸɽ
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');

        if (operator != null) {
            Operator o = operator;
            sb.append(o.toString());
            while ((o = o.nextOperator) != null) {
                sb.append(", ");
                sb.append(o.toString());
            }
        }

        sb.append(')');
        return sb.toString();
    }

//### Operator
    /** 쥯γ */
    private final class Operator {
        private static final int ALL = -20;     // ٤Ƥ
        // 
        private static final int OWN         = 0;              // ʬ
        private static final int ANCESTOR    = 1;              // 
        private static final int PARENT      = 2;              // ľܤο
        private static final int PREDECESSOR = 3;              // ľ

        // 롼ȤΤ
        private boolean  hasPseudo;         // 饹ǤäƤ뤫
        private Operator nextOperator;      // OR , ڤ

        // ٤
        private Operator nestedOperator;    // AND ʥ쥯

        private int            combinator;
        private int            targetType;
        private AttributeChain targetAttribute;
        private StringChain    targetClass;
        private StringChain    targetId;
        private int            pseudoClasses;
        private int            pseudoElements;
        private String         pseudoLang;

        private String[]   tokenClass;
        private String     tokenId;
        private Attribute  tokenAttribute;

        /** 󥹥󥹤 */
        private Operator(Operator nested) {
            this.nestedOperator = nested;
        }

        /** °ɲ */
        private void addAttribute(String key, String value, int match) {
            if (targetAttribute == null) {
                targetAttribute = new AttributeChain(key, value, match);
            } else {
                targetAttribute.add(key, value, match);
            }
        }

        /** 饹ɲ */
        private void addClass(String value) {
            if (targetClass == null) {
                targetClass = new StringChain(value);
            } else {
                targetClass.add(value);
            }
        }

        /** ID ɲ */
        private void addId(String value) {
            if (targetId == null) {
                targetId = new StringChain(value);
            } else {
                targetId.add(value);
            }
        }

        /** ȡ󤬤ȹפ뤫Ĵ٤ */
        private int isMatch(StartToken token) {
            switch (combinator) {
            case OWN:
                return isInnerMatch(token);
            case PARENT:
                for (;;) {
                    if ((token = token.getParent()) == null) {
                        return FALSE;
                    }
                    if (!token.getCompleteToken()) {
                        break;
                    }
                }
                return isInnerMatch(token);
            case PREDECESSOR:
                for (;;) {
                    if ((token = token.getBeforeStartToken()) == null) {
                        return FALSE;
                    }
                    if (!token.getCompleteToken()) {
                        break;
                    }
                }
                return isInnerMatch(token);
            case ANCESTOR:
                {
                    int ret;
                    do {
                        for (;;) {
                            if ((token = token.getParent()) == null) {
                                return FALSE;
                            }
                            if (!token.getCompleteToken()) {
                                break;
                            }
                        }
                    } while ((ret = isInnerMatch(token)) == FALSE);
                    return ret;
                }
            default: // AVOID
            }

            return FALSE;
        }

        /** ȡ󤬡Υ쥯ȹפ뤫Ĵ٤ */
        private int isInnerMatch(StartToken token) {
            // ̾Υå
            if (targetType != ALL && targetType != token.getType()) {
                return FALSE;
            }

            tokenAttribute = token.getAttribute();
            if (tokenAttribute != null) {
                tokenClass = tokenAttribute.getBaseClass();
                tokenId    = tokenAttribute.getBaseId   ();
            } else {
                tokenClass = null;
                tokenId    = null;
            }

            // °쥯Υå
            if (targetAttribute != null
                    && (tokenAttribute == null || !targetAttribute.isMatch(tokenAttribute))) {
                return FALSE;
            }

            // 饹쥯Υå
            if (targetClass     != null
                    && (tokenClass     == null || !targetClass    .isMatch(tokenClass    ))) {
                return FALSE;
            }

            // ID 쥯Υå
            if (targetId        != null
                    && (tokenId        == null || !targetId       .isMatch(tokenId        ))) {
                return FALSE;
            }

            // ʣ
            if (nestedOperator != null) {
                int ret = nestedOperator.isMatch(token);
                if (ret != TRUE) {
                    return ret;
                }
            }

            // ʣüǡ饹ǻǤϤʤ
            return (pseudoClasses != 0 || pseudoElements != 0
                    ? PSEUDO
                    : TRUE);
        }

        /** 饹Ǥȹפ뤫Ĵ٤ */
        private boolean isMatch(int pseudo) {
            return (((pseudoClasses  & pseudo) == pseudoClasses ) // 饹
                 && ((pseudoElements & pseudo) == pseudoElements) // 
                 && (nestedOperator == null
                  || nestedOperator.isMatch(pseudo)));            // ʣ
        }

        /** Υ쥯ʸɽ֤ */
        public String toString() {
            StringBuffer sb = new StringBuffer();

            if (nestedOperator != null) {
                sb.append(nestedOperator.toString());
                sb.append(' ');
            }

            if (targetType == ALL) {
                sb.append('*');
            } else {
                sb.append(TokenTypes.getName(targetType));
            }

            if (targetAttribute != null) {
                AttributeChain ac = targetAttribute;
                do {
                    sb.append(ac.toString());
                } while ((ac = ac.next) != null);
            }

            if (targetClass != null) {
                StringChain sc = targetClass;
                do {
                    sb.append('.');
                    sb.append(sc.value);
                } while ((sc = sc.next) != null);
            }

            if (targetId != null) {
                StringChain sc = targetId;
                do {
                    sb.append('#');
                    sb.append(sc.value);
                } while ((sc = sc.next) != null);
            }

            if (pseudoClasses != 0) {
                if ((pseudoClasses & Render.PSEUDO_FIRST_CHILD) != 0) { sb.append(":first-child"); }
                if ((pseudoClasses & Render.PSEUDO_LINK       ) != 0) { sb.append(":link"       ); }
                if ((pseudoClasses & Render.PSEUDO_VISITED    ) != 0) { sb.append(":visited"    ); }
                if ((pseudoClasses & Render.PSEUDO_HOVER      ) != 0) { sb.append(":hover"      ); }
                if ((pseudoClasses & Render.PSEUDO_ACTIVE     ) != 0) { sb.append(":active"     ); }
                if ((pseudoClasses & Render.PSEUDO_FOCUS      ) != 0) { sb.append(":focus"      ); }
                if ((pseudoClasses & Render.PSEUDO_LANG       ) != 0) {
                    sb.append(":lang(");
                    sb.append(pseudoLang);
                    sb.append(')');
                }
            }

            if (pseudoClasses != 0) {
                if ((pseudoElements & Render.PSEUDO_FIRST_LINE  ) != 0) { sb.append(":first-line"  ); }
                if ((pseudoElements & Render.PSEUDO_FIRST_LETTER) != 0) { sb.append(":first-letter"); }
                if ((pseudoElements & Render.PSEUDO_BEFORE      ) != 0) { sb.append(":before"      ); }
                if ((pseudoElements & Render.PSEUDO_AFTER       ) != 0) { sb.append(":after"       ); }
            }

            switch (combinator) {
            case PARENT     : sb.append(" >"); break;
            case PREDECESSOR: sb.append(" +"); break;
            default: // AVOID
            }

            return sb.toString();
        }
    }

//### AttributeChain
    /** ° */
    private final class AttributeChain {
        private AttributeChain next;

        /** 󥹥󥹤 */
        private AttributeChain(String key, String value, int match) {
            //### TODO
        }

        /** Ǹɲ */
        private void add(String key, String value, int match) {
        }

        /** פ뤫Ĵ٤ */
        private boolean isMatch(Attribute attribute) {
            return false;
        }

        /** ʸɽ֤ */
        public String toString() {
            //### TODO
            return "[]";
        }
    }

//### StringChain
    /** ° */
    private final class StringChain {
        private String      value;
        private StringChain next;
        private StringChain last;

        /** 󥹥󥹤 */
        private StringChain(String value) {
            this.value = value;
        }

        /** Ǹɲ */
        private void add(String value) {
            StringChain sc = new StringChain(value);
            if (last == null) {
                next = sc;
            } else {
                last.next = sc;
            }
            last = sc;
        }

        /** פ뤫Ĵ٤ */
        private boolean isMatch(String v) {
            if (v.compareTo(value) != 0) {
                return false;
            }

            return (next == null);
        }

        /** פ뤫Ĵ٤ */
        private boolean isMatch(String[] v) {
            StringChain sc = this;
            int i;

            CHECK:
            do {
                for (i = 0; i < v.length; i++) {
                    if (v[i].compareTo(sc.value) == 0) {
                        continue CHECK;
                    }
                }
                return false;
            } while ((sc = sc.next) != null);

            return true;
        }
    }
}
