/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.ruby;

import net.hizlab.kagetaka.rendering.Canvas;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.FormItem;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.rendering.block.Block;
import net.hizlab.kagetaka.rendering.block.FloatBlock;
import net.hizlab.kagetaka.rendering.block.Lines;
import net.hizlab.kagetaka.rendering.block.Wadge;
import net.hizlab.kagetaka.token.Value;

/**
 * ʸRTˤɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
class RtWadge extends Wadge {
    /**
     * ʸޤ
     *
     * @param  drawkit ɥå
     * @param  status  ơ
     * @param  parent  ƥ֥å
     */
    RtWadge(Drawkit drawkit, Status status, Block parent) {
        super(drawkit, status, parent);
    }


    /** {@inheritDoc} */
    protected void append(String text, int begin, int end, boolean save) {
        //### BUGS 0xA 򥹥ڡ֤ɬפ
        super.append(text, begin, end, save);
    }

    /** {@inheritDoc} */
    protected void append(String src, String alt, Value width, Value height,
                          int border) {
        super.append(src, alt, width, height, border);
    }

    /** {@inheritDoc} */
    protected void append(FormItem item) {
        super.append(item);
    }

    /** {@inheritDoc} */
    protected void append(FloatBlock block) {
        super.append(block);
    }

    /** {@inheritDoc} */
    protected void statusChanged(Status status) {
        super.statusChanged(status);
    }

    /** {@inheritDoc} */
    protected void restore() {
        super.restore();
    }

    /** {@inheritDoc} */
    protected void commit() {
        super.commit();
    }

    /** {@inheritDoc} */
    protected void validate(Lines lines, int awidth) {
        // ʸϸƤӽФʤ
        throw new IllegalStateException("internal error");
    }

    /** {@inheritDoc} */
    protected void draw(Canvas canvas, Lines lines) {
        super.draw(canvas, lines);
    }

    /**
     * ʸĹ֤ޤ
     *
     * @return ʸĹ
     */
    int getLength() {
        return valuesLength;
    }

    /**
     * Ƥ֤ޤ
     *
     * @return 
     */
    int getCount() {
        return heights.length();
    }

    /**
     * ֤ޤ
     *
     * @return 
     */
    int[] getWidths() {
        return widths.getInts();
    }

    /**
     * ⤵֤ޤ
     *
     * @return ⤵
     */
    int[] getHeights() {
        return heights.getInts();
    }

    /**
     * ֤ޤ
     *
     * @return 
     */
    char[] getTypes() {
        return types.getChars();
    }

    /**
     * ι⤵֤ޤ
     *
     * @return ι⤵
     */
    int getMaxHeight() {
        return maxHeight;
    }

    /**
     * ι⤵ꤷޤ
     *
     * @param  maxHeight ι⤵
     */
    void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    /**
     * ǥȤꤷޤ
     *
     * @param  indent ǥ
     */
    void setIndent(int indent) {
        this.indent = indent;
    }

    /**
     * եåȤꤷޤ
     *
     * @param  offset եå
     */
    void setOffset(int offset) {
        this.offset = offset;
    }
}
