/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.ruby;

import net.hizlab.kagetaka.rendering.Canvas;
import net.hizlab.kagetaka.rendering.Constant;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.FormItem;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.rendering.block.Block;
import net.hizlab.kagetaka.rendering.block.FloatBlock;
import net.hizlab.kagetaka.rendering.block.Lines;
import net.hizlab.kagetaka.rendering.block.Wadge;
import net.hizlab.kagetaka.token.Value;

/**
 * ӤоʸRBˤɽޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.6 $
 */
class RbWadge extends Wadge {
    private static final int THIS   = 0;
    private static final int RT     = 1;
    private static final int IGNORE = 2;

    private Status  status;                 // ơ
    private int     appendTo;               // ɲ
    private RtWadge rtWadge;                // ʸ
    private int     rtWidth;                // ʸ

    /**
     * оʸޤ
     *
     * @param  drawkit ɥå
     * @param  status  ơ
     * @param  parent  ƥ֥å
     */
    RbWadge(Drawkit drawkit, Status status, Block parent) {
        super(drawkit, status, parent);

        this.status = status;
    }

    /** {@inheritDoc} */
    protected void append(String text, int begin, int end, boolean save) {
//Debug.out.println("ruby=["+text.substring(begin, end)+"]");
        switch (appendTo) {
        case THIS:
            super.append(text, begin, end, save);
            break;
        case RT:
            checkRtWadge();
            rtWadge.append(text, begin, end, save);
            break;
        default: // AVOID
        }
    }

    /** {@inheritDoc} */
    protected void append(String src, String alt, Value width, Value height,
                          int border) {
        switch (appendTo) {
        case THIS:
            super.append(src, alt, width, height, border);
            break;
        case RT:
            checkRtWadge();
            rtWadge.append(src, alt, width, height, border);
            break;
        default: // AVOID
        }
    }

    /** {@inheritDoc} */
    protected void append(FormItem item) {
        switch (appendTo) {
        case THIS:
            super.append(item);
            break;
        case RT:
            checkRtWadge();
            rtWadge.append(item);
            break;
        default: // AVOID
        }
    }

    /** {@inheritDoc} */
    protected void append(FloatBlock block) {
        switch (appendTo) {
        case THIS:
            super.append(block);
            break;
        case RT:
            checkRtWadge();
            rtWadge.append(block);
            break;
        default: // AVOID
        }
    }

    /** {@inheritDoc} */
    protected void append(char c, char t, int r, int w, int h,
                          boolean before, boolean after, boolean save) {
        super.append(c, t, r, w, h, false, false, save);
    }

    /** {@inheritDoc} */
    protected void setRuby(int mode) {
        switch (mode) {
        case Constant.RUBY_RB:
            appendTo = THIS;
            break;
        case Constant.RUBY_RP:
            appendTo = IGNORE;
            break;
        case Constant.RUBY_RT:
            appendTo = RT;
            break;
        default: // AVOID
        }
    }

    /** {@inheritDoc} */
    protected void statusChanged(Status status) {
        switch (appendTo) {
        case THIS:
            super.statusChanged(status);
            this.status = status;
            break;
        case RT:
            checkRtWadge();
            rtWadge.statusChanged(status);
            break;
        default: // AVOID
        }
    }

    /** {@inheritDoc} */
    protected void commit() {
        super.commit();
        if (rtWadge != null) {
            rtWadge.restore();              // ʸκǸΥڡϺ
            rtWadge.commit ();

            int spaceHeight = rtWadge.getMaxHeight() - maxHeight;

            // ʸ֤Ĵ
            if (spaceHeight != 0) {
                int    length;
                int    count;
                int [] heights;
                char[] types;
                if (spaceHeight > 0) {
                    length  = this.valuesLength;
                    count   = this.heights.length  ();
                    heights = this.heights.getInts ();
                    types   = this.types  .getChars();
                } else {
                    length  = rtWadge.getLength ();
                    count   = rtWadge.getCount  ();
                    heights = rtWadge.getHeights();
                    types   = rtWadge.getTypes  ();
                }
                int odd    = Math.abs(spaceHeight);
                int indent = (int) Math.ceil(((double) odd) / length / 2);
                int diff;

                // ʸ֤Ĵ
                for (int i = count - 1; i >= 0; i--) {
                    switch (types[i]) { // ʸȤƿʤ
                    case TYPE_BLOCK:
                    case TYPE_ATTR :
                    case TYPE_ID   :
                    case TYPE_FLOAT:
                    case TYPE_NULL :
                        continue;
                    default: // AVOID
                    }
                    diff = odd / length;
                    heights[i] += diff;
                    odd        -= diff;
                    length--;
                }
                // ǥ̤
                if (spaceHeight > 0) {
                    this.indent    = indent;
                    this.maxHeight = rtWadge.getMaxHeight();
                } else {
                    rtWadge.setIndent   (indent   );
                    rtWadge.setMaxHeight(maxHeight);
                }
            }

            int[] widths;
            int   w, count;

            // ӥ١
            widths = this.widths.getInts();
            w      = 0;
            count  = heights.length();
            for (int i = count - 1; i >= 0; i--) {
                w = Math.max(w, widths[i]);
            }
            rtWadge.setOffset(w);

            // ʸ
            widths = rtWadge.getWidths();
            w      = 0;
            count  = rtWadge.getCount  ();
            for (int i = count - 1; i >= 0; i--) {
                w = Math.max(w, widths[i]);
            }
            rtWidth = w;
        }
    }

    /** {@inheritDoc} */
    protected void validate(Lines lines, int awidth) {
        super.validate(lines, awidth + rtWidth);
    }

    /** {@inheritDoc} */
    protected void draw(Canvas canvas, Lines lines) {
        if (rtWadge != null) {
            lines.saveDrawPosition();
            rtWadge.draw(canvas, lines);
            lines.rollbackDrawPosition();
        }
        super.draw(canvas, lines);
    }

//### private
    /** Ӥ뤫å */
    private void checkRtWadge() {
        if (rtWadge == null) {
            rtWadge = new RtWadge(drawkit, status, parent);
        }
    }
}
