/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.java2;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.util.Environment;

import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.Locale;

/**
 * Java2  AWT 򥵥ݡȤåѡ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public abstract class AWTWrapper {
    private static final String RESOURCE = "net.hizlab.kagetaka.addin.java2.Resources";

    /** 粽ʤ */
    public static final int MAXIMIZED_NONE  = 0;
    /** ˺粽 */
    public static final int MAXIMIZED_VERT  = 1;
    /** ˺粽 */
    public static final int MAXIMIZED_HORIZ = 2;
    /** Ĳ˺粽 */
    public static final int MAXIMIZED_BOTH  = MAXIMIZED_VERT | MAXIMIZED_HORIZ;

    private static AWTWrapper wrapper;
    static {
        if (Environment.javaVersion >= 102) {
            try {
                wrapper = (AWTWrapper) Class.forName(Resource.getMessage(RESOURCE, "bridge.awt", null)).newInstance();
            } catch (Throwable e) { }
        }
    }

    /**
     * 󥹥󥹤ޤ
     */
    protected AWTWrapper() {
    }

    /**
     * åѡΥ󥹥󥹤֤ޤ
     *
     * @return åѡΥ󥹥
     */
    public static AWTWrapper getInstance() {
        return wrapper;
    }

    /**
     * Ѳǽʤ٤ƤΥեȥեߥ
     * ϰб̾ǼƤ֤ޤ
     *
     * @param  l 
     *
     * @return եȥեߥΰ
     *
     * @see    java.awt.GraphicsEnvironment#getAvailableFontFamilyNames()
     */
    public abstract String[] getAvailableFontFamilyNames(Locale l);

    /**
     * ꤵ줿եȤǡʸɽǤ뤫֤ޤ
     *
     * @param  font ե
     * @param  c    ƥȤʸ
     *
     * @return ɽǤ <code>true</code>
     *         ʳξ <code>false</code>
     *
     * @see    Font#canDisplay(char)
     */
    public abstract boolean canFontDisplay(Font font, char c);

    /**
     * ѹΥ쥤ȤưŪѹǤ뤫ɤꤷޤ
     *
     * @param  toolkit оݤ AWT ġ륭å
     * @param  dynamic ưŪѹǤ褦ˤ <code>true</code>
     *                 ʤ <code>false</code>
     *
     * @see    Toolkit#setDynamicLayout(boolean)
     */
    public abstract void setDynamicLayout(Toolkit toolkit, boolean dynamic);

    /**
     * ե졼κ粽ξ֤֤ޤ
     *
     * @param  frame ե졼
     *
     * @return 粽ξ
     *
     * @see    Frame#getExtendedState()
     */
    public abstract int getFrameMaximized(Frame frame);

    /**
     * ե졼粽ޤ
     *
     * @param  frame ե졼
     * @param  state 粽ξ
     *
     * @see    Frame#getExtendedState()
     */
    public abstract void setFrameMaximized(Frame frame, int state);

    /**
     * ꥢ󥰤̵ͭꤷޤ
     *
     * @param  g եå
     * @param  b ˤ <code>true</code>
     *           դˤ <code>false</code>
     *
     * @see    java.awt.Graphics2D#setRenderingHint(java.awt.RenderingHints.Key, Object)
     */
    public abstract void setAntiAliasing(Graphics g, boolean b);
}
