/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.frame;

import net.hizlab.kagetaka.rendering.FrameItem;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.token.frame.FramesetAttribute;

/**
 * <code>FRAMESET</code> ƥɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
class ItemFrameset extends Item {
    private Item[][] items;

    private Value[] rowValues;
    private Value[] colValues;
    private int     rowIndex;
    private int     colIndex;

    /**
     * ե졼ॻåȤޤ
     *
     * @param  token <code>FRAMESET</code> ȡ
     */
    ItemFrameset(StartToken token) {
        FramesetAttribute attribute = (FramesetAttribute) token.getAttribute();
        if (attribute != null) {
            rowValues = attribute.getRows();
            colValues = attribute.getCols();
        }
        if (rowValues == null || rowValues.length == 0) {
            rowValues = new Value[]{new Value(1, Value.UNIT_ASTERISK)};
        }
        if (colValues == null || colValues.length == 0) {
            colValues = new Value[]{new Value(1, Value.UNIT_ASTERISK)};
        }

        items = new Item[rowValues.length][colValues.length];
    }

    /** {@inheritDoc} */
    public FrameItem[][] getItems() {
        return items;
    }

    /** {@inheritDoc} */
    public String getName() {
        return null;
    }

    /** {@inheritDoc} */
    public String getSrc() {
        return null;
    }

    /** {@inheritDoc} */
    public boolean getResize() {
        return false;
    }

    /** {@inheritDoc} */
    public int getScrolling() {
        return Value.INHERIT;
    }

    /** {@inheritDoc} */
    public boolean getBorder() {
        return false;
    }

    /** {@inheritDoc} */
    public int getMargineWidth() {
        return 0;
    }

    /** {@inheritDoc} */
    public int getMargineHeight() {
        return 0;
    }

    /**
     * ƥɲäޤ
     *
     * @param  item ƥ
     */
    void addItem(Item item) {
        if (rowIndex >= rowValues.length) {
            return;
        }

        item.setSize(colValues[colIndex], rowValues[rowIndex]);
        items[rowIndex][colIndex] = item;

        // ǥåʤ
        if (++colIndex >= colValues.length) {
            rowIndex++;
            colIndex = 0;
        }
    }

    /**
     * ߥåȤޤ
     */
    void commit() {
        int r, c;
        int colNum = colValues.length;
        Item item;

        // ̤Υե졼ॻåȤ⥳ߥåȤ
        for (r = 0; r < rowIndex; r++) {
            for (c = 0; c < colNum; c++) {
                if ((item = items[r][c]) instanceof ItemFrameset) {
                    ((ItemFrameset) item).commit();
                }
            }
        }

        if ((r = rowIndex) >= rowValues.length) {
            return;
        }

        for (c = 0; c < colIndex; c++) {
            if ((item = items[r][c]) instanceof ItemFrameset) {
                ((ItemFrameset) item).commit();
            }
        }

        // frame λ꤬­ʤ
        for (c = colIndex; c < colNum; c++) {
            items[r][c] = item = new ItemFrame(null);
            item.setSize(colValues[c], rowValues[r]);
        }
        rowIndex++;

        for (r = rowIndex; r < rowValues.length; r++) {
            for (c = 0; c < colNum; c++) {
                items[r][c] = item = new ItemFrame(null);
                item.setSize(colValues[c], rowValues[r]);
            }
        }
    }
}
