/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.frame;

import net.hizlab.kagetaka.rendering.FrameItem;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.frame.FrameAttribute;

/**
 * <code>FRAME</code> ƥɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
class ItemFrame extends Item {
    private String  src;
    private String  name;
    private boolean resize;
    private int     scrolling;
    private boolean border;
    private int     margineWidth;
    private int     margineHeight;

    /**
     * ե졼ޤ
     *
     * @param  token <code>FRAMESET</code> ȡ
     */
    ItemFrame(StartToken token) {
        if (token == null) {
            return;
        }

        FrameAttribute attribute = (FrameAttribute) token.getAttribute();
        if (attribute != null) {
            src  = attribute.getSrc ();
            name = attribute.getName();
            resize        = !attribute.getNoresize();
            scrolling     = attribute.getScrolling();
            border        = (attribute.getFrameborder() == 1);

            if (/*---*/attribute.getMarginwidth () == null
                    && attribute.getMarginheight() == null) {
                // ޡ󤬻ꤵƤʤ˥ǥեͤ
                margineWidth  = 10;
                margineHeight = 15;
            } else {
                if (attribute.getMarginwidth() != null) {
                    margineWidth  = attribute.getMarginwidth ().intValue();
                }
                if (attribute.getMarginheight() != null) {
                    margineHeight = attribute.getMarginheight().intValue();
                }
            }
        }
    }

    /** {@inheritDoc} */
    public FrameItem[][] getItems() {
        return null;
    }

    /** {@inheritDoc} */
    public String getName() {
        return name;
    }

    /** {@inheritDoc} */
    public String getSrc() {
        return src;
    }

    /** {@inheritDoc} */
    public boolean getResize() {
        return resize;
    }

    /** {@inheritDoc} */
    public int getScrolling() {
        return scrolling;
    }

    /** {@inheritDoc} */
    public boolean getBorder() {
        return border;
    }

    /** {@inheritDoc} */
    public int getMargineWidth() {
        return margineWidth;
    }

    /** {@inheritDoc} */
    public int getMargineHeight() {
        return margineHeight;
    }
}
