/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.frame;

import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.token.StartToken;

import java.util.Stack;

/**
 * ե졼б뤿Υϥɥ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
public class FrameManager
       extends net.hizlab.kagetaka.addin.FrameManager {

    private HawkContext context;
    private Document    document;
    private Request     request;

    private ItemFrameset root;
    private Stack        stack;

    /**
     * ե졼ޥ͡ޤ
     *
     * @param  context  륳ƥ
     * @param  document ɥȾ
     * @param  request  ꥯ
     */
    FrameManager(HawkContext context, Document document, Request request) {
        this.context  = context;
        this.document = document;
        this.request  = request;
    }

    /** {@inheritDoc} */
    public void beginFrameset(StartToken token) {
        if (stack != null && stack.empty()) {
            return;
        }

        ItemFrameset frameset = new ItemFrameset(token);

        if (root == null) {
            root  = frameset;
            stack = new Stack();
        } else {
            ((ItemFrameset) stack.peek()).addItem(frameset);
        }

        stack.push(frameset);
    }

    /** {@inheritDoc} */
    public void endFrameset() {
        if (root == null || stack.empty()) {
            return;
        }

        stack.pop();
    }

    /** {@inheritDoc} */
    public void addFrame(StartToken token) {

        if (root == null || stack.empty()) {
            return;
        }

        ((ItemFrameset) stack.peek()).addItem(new ItemFrame(token));
    }

    /** {@inheritDoc} */
    public void commit() {
        if (root != null) {
            root.commit();
            context.setupPanel(document, root);
        }
    }
}
