/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.form;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Vector;

/**
 * ܥʤɤνԤ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
class PostData implements net.hizlab.kagetaka.rendering.PostData {
    private static final byte[] CRLF = {0x0D, 0x0A};
    private static final byte[] CONTENT_DISPOSITION = "Content-Disposition: form-data; name=\"".getBytes();
    private static final byte[] FILENAME            = "; filename=\"".getBytes();
    private static final byte[] CONTENT_TYPE        = "Content-Type: ".getBytes();
    private static final int    BUFFER_SIZE = 512;

    private String data;
    private Vector items;
    private String boundary;
    private int    length;
    private String encoding;

    /**
     * ǡޤ
     *
     * @param  data ǡ
     */
    PostData(String data) {
        this.data   = data;
        this.length = data.length();
    }

    /**
     * ޥѡѤǡޤ
     *
     * @param  items    ƥ
     * @param  boundary Х
     * @param  length   Ĺ
     * @param  encoding 󥳡ǥ
     */
    PostData(Vector items, String boundary, int length, String encoding) {
        this.items    = items;
        this.boundary = boundary;
        this.length   = length;
        this.encoding = encoding;
    }

    /** {@inheritDoc} */
    public void send(URLConnection connection)
            throws IOException {
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection) connection).setRequestMethod("POST");
        }
        if (boundary != null) {
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        }
        connection.setRequestProperty("Content-Length", String.valueOf(length));
        connection.setDoOutput(true);

        OutputStream os = connection.getOutputStream();

        try {
            if (boundary == null) {
                if (data.length() == 0) {
                    return;
                }

                os.write(data.getBytes());
            } else {
                BufferedOutputStream bos = new BufferedOutputStream(os, BUFFER_SIZE);
                // 
                int size = items.size();
                Item item;
                byte[] bboundary = ("--" + boundary).getBytes();
                for (int i = 0; i < size; i++) {
                    item = (Item) items.elementAt(i);

                    // -----xxx
                    bos.write(bboundary);
                    bos.write(CRLF);
                    // Content-Disposition: form-data; name=""
                    bos.write(CONTENT_DISPOSITION);
                    write(bos, item.name, encoding);
                    bos.write('"');

                    if (item.type == null) {
                        bos.write(CRLF);
                        bos.write(CRLF);

                        // ͤ
                        write(bos, item.value, encoding);
                        bos.write(CRLF);
                    } else {
                        // ; filename=""
                        bos.write(FILENAME);
                        write(bos, (new File(item.value)).getName(), encoding);
                        bos.write('"');
                        bos.write(CRLF);
                        // Content-Type:
                        bos.write(CONTENT_TYPE);
                        write(bos, item.type, encoding);
                        bos.write(CRLF);
                        bos.write(CRLF);

                        // եž
                        if (item.value != null && item.value.length() > 0) {
                            try {
                                BufferedInputStream is = new BufferedInputStream(new FileInputStream(item.value), BUFFER_SIZE);
                                byte[] buffer  = new byte[BUFFER_SIZE];
                                int    readlen = 0;
                                try {
                                    while ((readlen = is.read(buffer, 0, BUFFER_SIZE)) != -1) {
                                        bos.write(buffer, 0, readlen);
                                    }
                                } finally {
                                    is.close();
                                }
                            } catch (FileNotFoundException e) {
                                // ̵
                            }
                        }
                        bos.write(CRLF);
                    }
                }

                if (boundary != null) {
                    bos.write(bboundary);
                    bos.write('-');
                    bos.write('-');
                    bos.write(CRLF);
                }

                bos.flush();
            }
        } finally {
            os.close();
        }
    }

    /** 񤭹 */
    private void write(OutputStream os, String value, String encoding)
            throws IOException {
        try {
            if (encoding == null) {
                os.write(value.getBytes());
            } else {
                os.write(value.getBytes(encoding));
            }
        } catch (UnsupportedEncodingException e) { }
    }

//### Item
    /** ƥ */
    static class Item {
        private String name;
        private String value;
        private String type;

        /**
         * 󥹥󥹤ޤ
         *
         * @param  name  ̾
         * @param  value 
         * @param  type  
         */
        Item(String name, String value, String type) {
            this.name  = name;
            this.value = value;
            this.type  = type;
        }
    }
}
