/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.form;

import net.hizlab.kagetaka.awt.tate.FileField;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.util.ContentType;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import java.text.ParseException;

/**
 * <code>INPUT TYPE="file"</code> ɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
class ItemFileField extends Item {
    private FileField file;

    /**
     * եեɤޤ
     *
     * @param  form     ե
     * @param  type     
     * @param  status   ơ
     * @param  name     ̾
     * @param  value    
     * @param  c        ݡͥ
     * @param  snapshot ɽκǸξ
     */
    ItemFileField(Form form, int type, Status status, String name, String value,
                  FileField c, Object snapshot) {
        super(form, type, status, name, value, c);
        this.file = c;

        // ξ֤
        if (snapshot != null) {
            c.setFile((String) snapshot);
        }
    }

    /** {@inheritDoc} */
    String getValue() {
        return file.getFile();
    }

    /** {@inheritDoc} */
    Object getSnapshot() {
        return file.getFile();
    }

    /** {@inheritDoc} */
    void reset() {
        file.setFile(defaultValue);
    }

    /**
     * ƥȥפ֤ޤ
     *
     * @return ƥȥ
     */
    String getContentType() {
        File file = new File(this.file.getFile());
        if (file.exists()) {
            try {
                URL url = new URL("file:" + file.getCanonicalPath());
                ContentType contentType = ContentType.valueOf(null, url);
                if (contentType != null && contentType != ContentType.CT_CONTENT_UNKNOWN) {
                    return contentType.toString();
                }
            } catch (ParseException e) {
                // ̵
            } catch (MalformedURLException e) {
                // ̵
            } catch (IOException e) {
                // ̵
            }
        }
        return "application/octet-stream";
    }
}
