/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.form;

import net.hizlab.kagetaka.rendering.FormItem;
import net.hizlab.kagetaka.rendering.Status;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;

/**
 * եॢƥɽå饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
abstract class Item implements FormItem {
    static final int TEXT     =  1;
    static final int PASSWORD =  2;
    static final int CHECKBOX =  3;
    static final int RADIO    =  4;
    static final int SUBMIT   =  5;
    static final int RESET    =  6;
    static final int FILE     =  7;
    static final int HIDDEN   =  8;
    static final int IMAGE    =  9;
    static final int LIST     = 10;
    static final int CHOICE   = 11;
    static final int TEXTAREA = 12;
    static final int BUTTON   = 13;

    final Form      form;
    final int       type;
    final Status    status;
    final String    name;
    final String    defaultValue;
    final Component component;

    private Dimension size;
    private Point     position;
    private boolean   visible = true;

    /**
     * եॢƥޤ
     *
     * @param  form   ե
     * @param  type   
     * @param  status ơ
     * @param  name   ̾
     * @param  value  
     * @param  c      ݡͥ
     */
    Item(Form form, int type, Status status, String name, String value, Component c) {
        this.form         = form;
        this.type         = type;
        this.status       = status;
        this.name         = name;
        this.defaultValue = value;
        this.component    = c;
        if (c == null) {
            this.visible = false;
        }
    }

    /** {@inheritDoc} */
    public synchronized void setup() {
        if (component != null) {
            component.setFont(status.font);
        }
    }

    /** {@inheritDoc} */
    public synchronized Dimension getSize() {
        if (size == null) {
            size = component.getPreferredSize();
        }

        return size;
    }

    /** {@inheritDoc} */
    public void show() {
        form.context.addFormItem(this);
    }

    /** {@inheritDoc} */
    public void setPosition(int x, int y) {
        position = new Point(x, y);
    }

    /** {@inheritDoc} */
    public Point getPosition() {
        return position;
    }

    /** {@inheritDoc} */
    public boolean isNeedBackImage() {
        return false;
    }

    /** {@inheritDoc} */
    public void setBackImage(Image image) {
    }

    /** {@inheritDoc} */
    public Component getComponent() {
        return component;
    }

    /** {@inheritDoc} */
    public void dispose() {
    }

    /**
     * ɽ륢ƥफ֤ޤ
     *
     * @return ɽ륢ƥξ <code>true</code>
     *         ɽʤ <code>false</code>
     */
    boolean isVisible() {
        return visible;
    }

    /**
     * ɽ륢ƥफꤷޤ
     *
     * @param  b ɽ륢ƥξ <code>true</code>
     *           ɽʤ <code>false</code>
     */
    void setVisible(boolean b) {
        visible = b;
    }

    /**
     * ʣ֤ͤ뤫ɤ֤ޤ
     *
     * @return ʣ֤ͤ <code>true</code>
     *         ֤ʤ <code>false</code>
     */
    boolean getMultipleMode() {
        return false;
    }

    /**
     * ͭɤ֤ޤ
     *
     * @return ͭξ <code>true</code>
     *         ̵ξ <code>false</code>
     */
    boolean isEnabled() {
        if (component != null) {
            return component.isEnabled();
        }

        return true;
    }

    /**
     * ֤ͤޤ
     *
     * @return 
     */
    String getValue() {
        return null;
    }

    /**
     * ֤ͤޤ
     *
     * @return 
     */
    String[] getValues() {
        return null;
    }

    /**
     * ξ֤뤿ξ֤ޤ
     *
     * @return ξ֤뤿ξ
     */
    abstract Object getSnapshot();

    /**
     * ͤꥻåȤޤ
     */
    abstract void reset();
}
