/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin.form;

import net.hizlab.kagetaka.Debug;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ImageButton;
import net.hizlab.kagetaka.awt.image.RotateFilter;
import net.hizlab.kagetaka.awt.tate.Button;
import net.hizlab.kagetaka.awt.tate.Checkbox;
import net.hizlab.kagetaka.awt.tate.CheckboxGroup;
import net.hizlab.kagetaka.awt.tate.Choice;
import net.hizlab.kagetaka.awt.tate.FileField;
import net.hizlab.kagetaka.awt.tate.List;
import net.hizlab.kagetaka.awt.tate.TextArea;
import net.hizlab.kagetaka.awt.tate.TextField;
import net.hizlab.kagetaka.net.URLEncoder;
import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.rendering.StopException;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.form.FormAttribute;
import net.hizlab.kagetaka.token.form.InputAttribute;
import net.hizlab.kagetaka.token.form.OptionAttribute;
import net.hizlab.kagetaka.token.form.SelectAttribute;
import net.hizlab.kagetaka.token.form.TextareaAttribute;
import net.hizlab.kagetaka.util.Charset;
import net.hizlab.kagetaka.util.TextFormat;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.NoSuchElementException;

/**
 * ե֥åɽ饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.10 $
 */
class Form {
    private static final String RESOURCE = "net.hizlab.kagetaka.addin.form.Resources";

    final HawkContext context;
    final Document    document;
    final Request     request;
    final Option      option;

    private StartToken  formToken;
    private Enumeration initialData;
    private Vector      items = new Vector();
    private Hashtable   radios;
    private ItemSelect  select;

    /**
     * եޤ
     *
     * @param  context     륳ƥ
     * @param  document    ɥȾ
     * @param  request     ꥯ
     * @param  token       ȡ
     * @param  initialData ǡ¸ߤʤ <code>null</code>
     */
    Form(HawkContext context, Document document, Request request,
         StartToken token, Enumeration initialData) {
        this.context     = context;
        this.document    = document;
        this.request     = request;
        this.option      = context.getOption();
        this.formToken   = token;
        this.initialData = initialData;
    }

    /**
     * եॢƥɲäޤ
     *
     * @param  token  <code>INPUT</code> ϥ
     * @param  status ơ
     *
     * @return ɲä줿ƥࡢ
     *         ɽʤƥǤ <code>null</code> ֤
     */
    Item addItem(StartToken token, Status status) {
        Item item = null;

        InputAttribute attr = (InputAttribute) token.getAttribute();

        String type = null, name = null, value = null;
        boolean disabled = false, readonly = false;
        if (attr != null) {
            type     = attr.getType    ();
            name     = attr.getName    ();
            value    = attr.getValue   ();
            disabled = attr.getDisabled();
            readonly = attr.getReadonly();
        }

        if (type != null) {
            type = type.toLowerCase();
        }

        // text, password
        if (/*---*/type == null
                || type.compareTo("text"    ) == 0
                || type.compareTo("password") == 0) {
            int typeInt = (type != null && type.compareTo("password") == 0 ? Item.PASSWORD : Item.TEXT);
            int size    = (attr != null && attr.getSize() != null ? attr.getSize().intValue() : 20);
            TextField c = new TextField(option, context, value, size);
            if (disabled) {
                c.setEnabled(false);
            }
            if (readonly) {
                c.setLocked (true );
            }
            if (attr != null && attr.getMaxlength() != null) {
                c.setMaxLength(attr.getMaxlength().intValue());
            }

            // ѥ
            if (typeInt == Item.PASSWORD) {
                c.setEchoChar('*');
            }

            item = new ItemText(this, typeInt, status, name, value, c, nextSnapshot());
        } else

        // checkbox
        if (type.compareTo("checkbox") == 0) {
            boolean state = (attr != null ? attr.getChecked() : false);
            Checkbox c = new Checkbox(option, context, null, state);
            if (disabled) {
                c.setEnabled(false);
            }
            item = new ItemCheckbox(this, Item.CHECKBOX, status, name, value, c, nextSnapshot());
        } else

        // radio
        if (type.compareTo("radio") == 0) {
            boolean state = (attr != null ? attr.getChecked() : false);
            CheckboxGroup group = null;
            if (name != null) {
                if (radios == null) {
                    radios = new Hashtable();
                } else {
                    group = (CheckboxGroup) radios.get(name);
                }
            }
            if (group == null) {
                group = new CheckboxGroup();
                if (name != null) {
                    radios.put(name, group);
                }
            }

            Checkbox c = new Checkbox(option, context, null, state, group);
            if (disabled) {
                c.setEnabled(false);
            }
            item = new ItemCheckbox(this, Item.RADIO, status, name, value, c, nextSnapshot());
        } else

        // submit ܥ
        if (type.compareTo("submit") == 0) {
            String label = value;
            if (label == null) {
                label = Resource.getMessage(RESOURCE, "submit.default", null);
            }
            Button c = new Button(option, context, label);
            if (disabled) {
                c.setEnabled(false);
            }
            item = new ItemButton(this, Item.SUBMIT, status, name, value, c);
        } else

        // reset ܥ
        if (type.compareTo("reset") == 0) {
            String label = value;
            if (label == null) {
                label = Resource.getMessage(RESOURCE, "reset.default", null);
            }
            Button c = new Button(option, context, label);
            if (disabled) {
                c.setEnabled(false);
            }
            item = new ItemButton(this, Item.RESET, status, name, value, c);
        } else

        // file
        if (type.compareTo("file") == 0) {
            FileField c = new FileField(option, context, value);
            if (disabled) {
                c.setEnabled(false);
            }

            //### TODO ե륿ɲ

            item = new ItemFileField(this, Item.FILE, status, name, value, c, nextSnapshot());
        } else

        // hidden ƥ
        if (type.compareTo("hidden") == 0) {
            item = new ItemHidden(this, Item.HIDDEN, status, name, value, !disabled);
        } else

        // image ƥ
        if (type.compareTo("image") == 0) {
            String src = (attr != null ? attr.getSrc() : null);
//            String alt = (attr != null ? attr.getAlt() : null);
            Image image = null;
            try {
                if (src != null) {
//                    boolean spin    = false;
                    Content content = request.createRequest(document.createURL(src)).getContent(context, true);
                    if (content != null) {
                        Object object = content.getObject(Content.TYPE_IMAGE);
                        if (object instanceof Image) {
                            // 
                            image = (Image) object;
                            // ܥξϡɬž
                            //### BUGS ˤäѤ

                            // žβ
                            MediaTracker mt = context.getMediaTracker();
                            mt.addImage(image, 0);
                            try {
                                mt.waitForID(0, 30000);
                            } catch (InterruptedException e) {
                                throw new StopException("wait to load a source of image button");
                            }
                            boolean complete = (mt.statusID(0, true) == MediaTracker.COMPLETE);
                            mt.removeImage(image, 0);

                            // ž
                            if (complete) {
                                image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(),
                                                                                                        new RotateFilter()));
                            } else {
                                image.flush();
                                image = null;
                            }
                        }
                    }
                }
            } catch (SecurityException e) {
                //### ERROR
Debug.out.println(e + "[" + src + "]");
            } catch (Exception e) {
                //### ERROR
Debug.out.println(e + "[" + src + "]");
            }
            if (image == null) {
                image = Resource.getImageResource("render.image.notfound", context.getToolkit());
                if (image == null) {
                    //### ERROR ѰդǤʤ
                    return null;
                }
            }

            ImageButton c = new ImageButton(false, image, image, image, image, null, null, null, null);
            if (disabled) {
                c.setEnabled(false);
            } else {
                c.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
            }

            item = new ItemImage(this, Item.IMAGE, status, name, value, c);
        }

        // λ
        if (item == null) {
            return null;
        }

        items.addElement(item);

        return (item.isVisible() ? item : null);
    }

    /**
     * SELECT 򳫻Ϥޤ
     *
     * @param  token  <code>SELECT</code> ϥ
     * @param  status ơ
     */
    void beginSelect(StartToken token, Status status) {
        SelectAttribute attr = (SelectAttribute) token.getAttribute();

        String  name = null;
        Integer size = null;
        boolean multiple = false;
        boolean disabled = false;
        if (attr != null) {
            name     = attr.getName    ();
            size     = attr.getSize    ();
            multiple = attr.getMultiple();
            disabled = attr.getDisabled();
        }

        if (size == null || size.intValue() == 1) {
            Choice c = new Choice(option, context);
            if (disabled) {
                c.setEnabled(false);
            }
            c.select(0);
            select = new ItemChoice(this, Item.CHOICE, status, name, c, nextSnapshot());
        } else {
            List c = new List(option, context, size.intValue(), multiple);
            if (disabled) {
                c.setEnabled(false);
            }
            select = new ItemList  (this, Item.LIST, status, name, c, nextSnapshot());
        }
    }

    /**
     * SELECT λޤ
     *
     * @return ɲä줿 SELECT ƥ
     */
    Item endSelect() {
        if (select == null) {
            return null;
        }

        items.addElement(select);

        Item item = select;
        select = null;

        return item;
    }

    /**
     * OPTION ɲäޤ
     *
     * @param  token <code>OPTION</code> ϥ
     */
    void addOption(StartToken token) {
        if (select == null) {
            return;
        }

        OptionAttribute attr = (OptionAttribute) token.getAttribute();

        String value = null, label = null;
        boolean selected = false;
        if (attr != null) {
            value    = attr.getValue   ();
            label    = attr.getLabel   ();
            selected = attr.getSelected();
        }

        if (label == null) {
            if ((label = token.getContent()) == null) {
                label = "";
            } else {
                label = TextFormat.convertXhtml(context.getReporter(),
                                                document.content,
                                                token.getLineNumber(),
                                                token.getColumnNumber(),
                                                label,
                                                true, true, true, true);
            }
        }
        if (value == null) {
            value = label;
        }

        select.addValue(value, label, selected);
    }

    /**
     * ƥȥꥢɲäޤ
     *
     * @param  token  <code>TEXTAREA</code> ϥ
     * @param  status ơ
     *
     * @return ɲä줿ƥࡢ
     *         ɽʤƥǤ <code>null</code> ֤
     */
    Item addTextarea(StartToken token, Status status) {
        TextareaAttribute attr = (TextareaAttribute) token.getAttribute();

        String name = null, wrap = null;
        Integer rows = null, cols = null;
        boolean disabled = false, readonly = false;
        if (attr != null) {
            name     = attr.getName    ();
            rows     = attr.getRows    ();
            cols     = attr.getCols    ();
            disabled = attr.getDisabled();
            readonly = attr.getReadonly();
            wrap     = attr.getWrap    ();
        }

        if (wrap != null) {
            wrap = wrap.toLowerCase();
        }

        String value = token.getContent();
        if (value != null) {
            int start = 0, end = value.length() - 1;
            if (end >= start && value.charAt(start) == 0x0D) { start++; }
            if (end >= start && value.charAt(start) == 0x0A) { start++; }
            if (end >  start && value.charAt(end  ) == 0x0A) { end--;   }
            if (end >  start && value.charAt(end  ) == 0x0D) { end--;   }

            if (start > 0 || end < value.length() - 1) {
                value = value.substring(start, end + 1);
            }
        }

        boolean wordwrap = (wrap != null && wrap.compareTo("off") != 0);
        TextArea c = new TextArea(option, context, value,
                                  ((rows == null || rows.intValue() <= 0) ?  2 : rows.intValue()),
                                  ((cols == null || cols.intValue() <= 0) ? 30 : cols.intValue()),
                                  (wordwrap ? TextArea.SCROLLBARS_HORIZONTAL_ONLY
                                            : TextArea.SCROLLBARS_BOTH));
        if (disabled) {
            c.setEnabled (false);
        }
        if (readonly) {
            c.setLocked  (true );
        }
        if (wordwrap) {
            c.setWordwrap(true );
        }

        Item item = new ItemText(this, Item.TEXTAREA, status, name, value, c, nextSnapshot());

        items.addElement(item);

        return (item.isVisible() ? item : null);
    }

    /**
     * եλޤ
     */
    void close() {
        int type = 0;

        // ƥȥեɤĤξ硢SUBMIT ǽɲ
        ItemText it = null;
        for (int i = items.size() - 1; i >= 0; i--) {
            type = ((Item) items.elementAt(i)).type;
            if (type == Item.TEXT || type == Item.PASSWORD) {
                if (it != null) {
                    it = null;
                    break;
                }
                it = (ItemText) items.elementAt(i);
            }
        }
        if (it != null) {
            it.addAction(new ActionSubmit(this, it));
        }
    }

    /**
     * ֥ߥåȤޤ
     *
     * @param  origin ֥ߥåȸ
     */
    void submit(Item origin) {
        submit(origin, 0, 0);
    }

    /**
     * ־դǥ֥ߥåȤޤ
     *
     * @param  origin ֥ߥåȸ
     * @param  x X
     * @param  y Y
     */
    void submit(Item origin, int x, int y) {
        if (formToken == null) {
            //### ERROR
Debug.out.println("can not submit");
            return;
        }

        URL     actionUrl = document.getBaseURL();
        boolean methodGet = true;
        String  encoding  = document.content.getEncoding();
        String  boundary  = null;

        // FORM °ͤ
        FormAttribute attr = (FormAttribute) formToken.getAttribute();
        if (attr != null) {
            String s = null;

            if ((s = attr.getAction()) != null) {
                try {
                    actionUrl = document.createURL(s);
                } catch (SecurityException e) {
                    //### ERROR
Debug.out.println(e + "[" + actionUrl + "],[" + s + "]");
                } catch (MalformedURLException e) {
                    //### ERROR
Debug.out.println(e + "[" + actionUrl + "],[" + s + "]");
                }
            }

            if ((s = attr.getMethod()) != null) {
                methodGet = (s.toUpperCase().compareTo("POST") != 0);
            }

            if (/*---*/(s = attr.getEnctype()) != null
                    && s.toLowerCase().compareTo("multipart/form-data") == 0) {
                DecimalFormat df = new DecimalFormat("00000000000000");
                df.setMaximumIntegerDigits(14);
                df.setMinimumIntegerDigits(14);
                boundary = "-----------------------------"
                         + df.format(Math.random() * 1.0e14d);
            }

            if ((s = attr.getAcceptCharset()) != null) {
                StringTokenizer st = new StringTokenizer(s, " ");
                while (st.hasMoreTokens()) {
                    if ((s = Charset.toEncoding(st.nextToken())) != null) {
                        encoding = s;
                        break;
                    }
                }
            }
        }

        int i, j, size = items.size();
        String name, value;
        int nameLen = 0;
        Item   item;

        String[]     values  = null;
        StringBuffer sb      = new StringBuffer();
        boolean      first   = true;
        String[]     v1      = new String[1];
        Vector       bitems  = new Vector();
        int          blen    = (boundary != null ? boundary.length() + 4 : 0); // --xxxxxxxxCRLF
        int          blength = blen + 2;        // ǽԤ --xxxxxxxx--CRLF

        // 
        for (i = 0; i < size; i++) {
            item = (Item) items.elementAt(i);

            // 1. name ̵ʤimage λ name ̵Ƥ
            // 2. disabled ʤ
            // 3. reset ܥʤ
            // 4. ܥϤϲܥΤ
            if (/*---*/(item.name == null && item.type != Item.IMAGE)
                    || !item.isEnabled()
                    || item.type == Item.RESET
                    || ((item.type == Item.SUBMIT
                      || item.type == Item.BUTTON
                      || item.type == Item.IMAGE) && item != origin)) {
                continue;
            }

            if (item.type == Item.IMAGE) {
                // ܥξ
                values = new String[]{String.valueOf(x), String.valueOf(y), item.getValue()};
            } else if (item.getMultipleMode()) {
                // ʣξ
                if ((values = item.getValues()) == null) {
                    continue;
                }
            } else {
                // ͤĤξ
                if ((v1[0] = item.getValue()) == null) {
                    continue;
                }
                values = v1;
            }

            name = null;
            // Ͱ
            for (j = 0; j < values.length; j++) {
                value = values[j];
                if (value == null) {
                    continue;
                }

                // ̾
                if (name == null || item.type == Item.IMAGE) {
                    if (item.type == Item.IMAGE) {
                        // image ξ name Ѥ
                        switch (j) {
                        case 0: name = (item.name != null ? item.name + ".x" : "x"); break;
                        case 1: name = (item.name != null ? item.name + ".y" : "y"); break;
                        case 2:
                            if (item.name == null) {
                                continue;
                            }
                            name = item.name;
                            break;
                        default: // AVOID
                        }
                    } else {
                        name = item.name;
                    }

                    if (boundary == null) {
                        name = URLEncoder.encode(name, encoding);
                    } else {
                        nameLen = calculateLength(name, encoding);
                    }
                }

                // ͤ
                if (boundary == null) {
                    if (!first) {
                        sb.append('&');
                    } else {
                        first = false;
                    }

                    sb.append(name);
                    sb.append('=');
                    sb.append(URLEncoder.encode(value, encoding));
                } else {
                    blength += blen;
                    blength += 45;                     // Content-Disposition: form-data; name=""CRLFCRLFCRLF
                    blength += nameLen;
                    if (item instanceof ItemFileField) {
                        ItemFileField iff = (ItemFileField) item;
                        String type = iff.getContentType();
                        File   file = new File(value);
                        blength += 13;                  // ; filename=""
                        blength += file.getName().length();
                        blength += 16;                  // Content-Type: CRLF
                        blength += type.length();
                        blength += file.length();
                        bitems.addElement(new PostData.Item(name, value, type));
                    } else {
                        blength += calculateLength(value, encoding);
                        bitems.addElement(new PostData.Item(name, value, null));
                    }

                }
            }
        }

//Debug.out.println(sb);
        URL      url;
        PostData pd;
        if (methodGet) {
            url = actionUrl;
            try {
                url = new URL(actionUrl.toExternalForm() + "?" + sb.toString());
            } catch (MalformedURLException e) {
                //### ERROR
Debug.out.println(e + "[" + actionUrl.toExternalForm() + "?" + sb.toString() + "]");
            }
            pd = null;
        } else if (boundary == null) {
            url = actionUrl;
            pd  = new PostData(sb.toString());
        } else {
            url = actionUrl;
Debug.out.println("* post.length=" + blength + "]");
            pd = new PostData(bitems, boundary, blength, encoding);
        }
        String   target = (attr.getTarget() != null)
                          ? attr.getTarget()
                          : document.getBaseTarget();
        context.openHawk(new Request(url, pd, document.content.url, target, Request.OPEN_DEFAULT, Request.CACHE_NORMAL));
    }

    /**
     * ꥻåȤޤ
     */
    void reset() {
        for (int i = items.size() - 1; i >= 0; i--) {
            ((Item) items.elementAt(i)).reset();
        }
    }

    /**
     * ƥΰޤ
     *
     * @return ƥΰ
     */
    Enumeration listItems() {
        return items.elements();
    }

    /** Υʥåץåȥǡ */
    private Object nextSnapshot() {
        try {
            return (initialData != null
                    ? initialData.nextElement()
                    : null);
        } catch (NoSuchElementException e) {
            //### ERROR
Debug.err.println("### ERROR ### Form.nextSnapshot : " + e);
e.printStackTrace(Debug.err);
        }
        return null;
    }

    /** Ĺ */
    private int calculateLength(String value, String encoding) {
        try {
            return (encoding == null
                    ? value.getBytes().length
                    : value.getBytes(encoding).length);
        } catch (UnsupportedEncodingException e) {
            return 0;
        }
    }
}
