/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.StartToken;

import java.io.IOException;

/**
 * б뤿Υޥ͡Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
public abstract class StyleManager {
    private static StyleManagerFactory styleManagerFactory;
    static {
        try {
            styleManagerFactory = (StyleManagerFactory) Class.forName(Resource.getMessage("stylemanager.factory", null)).newInstance();
        } catch (Throwable e) { }
    }

    /**
     * ޥ͡ޤ
     */
    protected StyleManager() {
    }

    /**
     * ޥ͡Υ󥹥󥹤ޤ
     *
     * @param  context  륳ƥ
     * @param  document ɥ
     * @param  request  ꥯ
     *
     * @return ޥ͡
     **/
    public static StyleManager createInstance(HawkContext context,
                                              Document document,
                                              Request request) {
        if (styleManagerFactory != null) {
            return styleManagerFactory.create(context, document, request);
        }

        reportMessage(document.content, context.getReporter());
        return null;
    }

    /** 顼 */
    private static void reportMessage(Content content, Reporter reporter) {
        if (reporter != null) {
            reporter.report(Reporter.STYLE, Reporter.WARNING, Reporter.NONE,
                            content, 0, 0,
                            "Style", Resource.getMessage("stylemanager.warning.notsupport", null));
        }
    }

    /**
     * ƥĤ饹ɤߡϿޤ
     *
     * @param  content Ϥǡ
     * @param  request ꥯ
     *
     * @throws IOException IO 顼ȯ
     */
    public abstract void addStyle(Content content, Request request)
            throws IOException;

    /**
     * ʸ󤫤饹ϤϿޤ
     *
     * @param  content Ϥǡ¸ߤ륳ƥ
     * @param  data    Ϥǡ
     */
    public abstract void addStyle(Content content, String data);

    /**
     * ݻƤ륹뤫顢оݤΥȡ򸵤ˡ
     * 襹ơѹޤ
     *
     * @param  media  оݤΥǥ
     * @param  token  оݤΥȡ
     * @param  status 襹ơ
     * @param  pseudo 饹
     */
    public abstract void changeStatus(int media, StartToken token, Status status,
                                      int pseudo);

//### Utils
    /**
     * ꥹѤʸ֤ޤ
     *
     * @param  type  ꥹȥ
     * @param  count 
     *
     * @return ʸ
     */
    public static String getListCounter(int type, int count) {
        if (styleManagerFactory != null) {
            return styleManagerFactory.getListCounter(type, count);
        }

        return null;
    }
}
