/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.addin;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Content;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.FormData;
import net.hizlab.kagetaka.rendering.FormItem;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Reporter;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.StartToken;

/**
 * եб뤿Υޥ͡Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public abstract class FormManager {
    private static FormManagerFactory formManagerFactory;
    static {
        try {
            formManagerFactory = (FormManagerFactory) Class.forName(Resource.getMessage("formmanager.factory", null)).newInstance();
        } catch (Throwable e) { }
    }

    /**
     * եޥ͡ޤ
     */
    protected FormManager() {
    }

    /**
     * եޥ͡Υ󥹥󥹤ޤ
     *
     * @param  context  륳ƥ
     * @param  document ɥȾ
     * @param  request  ꥯ
     *
     * @return եޥ͡
     **/
    public static FormManager createInstance(HawkContext context,
                                             Document document,
                                             Request request) {
        if (formManagerFactory != null) {
            return formManagerFactory.create(context, document, request);
        }

        reportMessage(document.content, context.getReporter());
        return null;
    }

    /** 顼 */
    private static void reportMessage(Content content, Reporter reporter) {
        if (reporter != null) {
            reporter.report(Reporter.TOKEN, Reporter.WARNING, Reporter.NONE,
                            content, 0, 0,
                            "Form", Resource.getMessage("formmanager.warning.notsupport", null));
        }
    }

    /**
     * ե򳫻Ϥޤ
     *
     * @param  token <code>FORM</code> ϥ
     */
    public abstract void beginForm(StartToken token);

    /**
     * եλޤ
     */
    public abstract void endForm();

    /**
     * եॢƥɲäޤ
     *
     * @param  token  <code>INPUT</code> ϥ
     * @param  status ơ
     *
     * @return ɲä줿ƥࡢ
     *         ɽʤƥǤ <code>null</code> ֤
     */
    public abstract FormItem addFormItem(StartToken token, Status status);

    /**
     * SELECT 򳫻Ϥޤ
     *
     * @param  token  <code>SELECT</code> ϥ
     * @param  status ơ
     */
    public abstract void beginSelect(StartToken token, Status status);

    /**
     * SELECT λޤ
     *
     * @return ɲä줿 SELECT ƥ
     */
    public abstract FormItem endSelect();

    /**
     * OPTION ɲäޤ
     *
     * @param  token <code>OPTION</code> ϥ
     */
    public abstract void addOption(StartToken token);

    /**
     * ƥȥꥢɲäޤ
     *
     * @param  token  <code>TEXTAREA</code> ϥ
     * @param  status ơ
     *
     * @return ɲä줿ƥࡢ
     *         ɽʤƥǤ <code>null</code> ֤
     */
    public abstract FormItem addTextarea(StartToken token, Status status);

    /**
     * ߤΥեξ֤¸ޤ
     *
     * @return ߤΥեξ
     */
    public abstract FormData save();
}
