/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka;

import net.hizlab.kagetaka.util.Environment;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * ǥǥХååɽ뤿Υ󥿡ե󶡤ޤ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public final class Debug {
    private static final String DEBUG_PROPERTY = "kagetaka.debug";

    /**
     * ǥХåϤԤäƤ <code>true</code>
     * ʳξ <code>false</code>
     */
    public static boolean isDebug;

    /**
     * ǥХåν
     */
    public static PrintWriter out;

    /**
     * 顼ν
     */
    public static PrintStream err;

    /** ٤¹ */
    static {
        boolean     isDebug = false;
        PrintWriter out     = null;
        try {
            try {
                //### TODO ץåȤξ⤦θɬפ
                isDebug = (Environment.isApplet || Boolean.getBoolean(DEBUG_PROPERTY));
                if (isDebug) {
                    out = new PrintWriter(System.out, true);
                }
            } catch (SecurityException e) { }

            if (out == null) {
                out = new PrintWriter(System.out, false) {
                    /** եå */
                    public void flush() {
                        // ̵
                    }

                    /** ʸ񤭹 */
                    public void write(int c) {
                        // ̵
                    }

                    /** ʸ񤭹 */
                    public void write(char[] buf, int off, int len) {
                        // ̵
                    }

                    /** ʸ񤭹 */
                    public void write(String s, int off, int len) {
                        // ̵
                    }

                    /** Ԥ񤭹 */
                    public void println() {
                        // ̵
                    }

                    /** ʸ񤭹ߡɬפʤȤ򲼤뤿 */
                    public void print(String s) {
                        // ̵
                    }
                };
            }
        } finally {
            Debug.isDebug = isDebug;
            Debug.out     = out;
            Debug.err     = System.out;
        }
    }

    /** ߡ */
    private Debug() {
    }
}
