/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.fclabs.util;

/**
 * BASE64 󥳡/ǥɤԤäꤷޤ
 *
 * @author  <A HREF="mailto:hizuya@fclabs.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public final class Base64 {
    private static byte[] base64EncMap, base64DecMap;

    static {
        // rfc-2045: Base64 Alphabet
        byte[] map = {
            (byte) 'A', (byte) 'B', (byte) 'C', (byte) 'D', (byte) 'E',
            (byte) 'F', (byte) 'G', (byte) 'H', (byte) 'I', (byte) 'J',
            (byte) 'K', (byte) 'L', (byte) 'M', (byte) 'N', (byte) 'O',
            (byte) 'P', (byte) 'Q', (byte) 'R', (byte) 'S', (byte) 'T',
            (byte) 'U', (byte) 'V', (byte) 'W', (byte) 'X', (byte) 'Y',
            (byte) 'Z',
            (byte) 'a', (byte) 'b', (byte) 'c', (byte) 'd', (byte) 'e',
            (byte) 'f', (byte) 'g', (byte) 'h', (byte) 'i', (byte) 'j',
            (byte) 'k', (byte) 'l', (byte) 'm', (byte) 'n', (byte) 'o',
            (byte) 'p', (byte) 'q', (byte) 'r', (byte) 's', (byte) 't',
            (byte) 'u', (byte) 'v', (byte) 'w', (byte) 'x', (byte) 'y',
            (byte) 'z',
            (byte) '0', (byte) '1', (byte) '2', (byte) '3', (byte) '4',
            (byte) '5', (byte) '6', (byte) '7', (byte) '8', (byte) '9',
            (byte) '+', (byte) '/',
        };
        base64EncMap = map;
        base64DecMap = new byte[128];
        for (int i = 0; i < base64EncMap.length; i++) {
            base64DecMap[base64EncMap[i]] = (byte) i;
        }
    }

    /**
     * ʸ BASE64 󥳡ɤޤ
     * ܤ RFC-2045 ( 6.8) 򻲾ȡ
     *
     * @param  data 2 Хʸޤʸ
     *
     * @return BASE64 Ѥƥ󥳡ɤ줿ʸ
     */
    public static byte[] encode(byte[] data) {
        if (data == null) { return  null; }

        int sidx, didx;
        byte[] dest = new byte[((data.length + 2) / 3) * 4];


        // 3-byte to 4-byte conversion + 0-63 to ascii printable conversion
        for (sidx = 0, didx = 0; sidx < data.length - 2; sidx += 3) {
            dest[didx++] = base64EncMap[(data[sidx    ] >>> 2) & 077];
            dest[didx++] = base64EncMap[(data[sidx + 1] >>> 4) & 017 | (data[sidx    ] << 4) & 077];
            dest[didx++] = base64EncMap[(data[sidx + 2] >>> 6) & 003 | (data[sidx + 1] << 2) & 077];
            dest[didx++] = base64EncMap[ data[sidx + 2] & 077];
        }
        if (sidx < data.length) {
            dest[didx++] = base64EncMap[(data[sidx] >>> 2) & 077];
            if (sidx < data.length - 1) {
                dest[didx++] = base64EncMap[(data[sidx + 1] >>> 4) & 017 | (data[sidx] << 4) & 077];
                dest[didx++] = base64EncMap[(data[sidx + 1] <<  2) & 077];
            } else {
                dest[didx++] = base64EncMap[(data[sidx] << 4) & 077];
            }
        }

        // add padding
        for (; didx < dest.length; didx++) {
                dest[didx] = (byte) '=';
        }

        return dest;
    }

    /**
     * ʸ BASE64 ǥɤޤ
     * ܤ RFC-2045 ( 6.8) 򻲾ȡ
     *
     * @param  data BASE64 Ѥƥ󥳡ɤ줿ʸ
     *
     * @return ǥɤ줿ʸ
     */
    public static byte[] decode(byte[] data) {
        if (data == null) { return null; }

        int tail = data.length;
        while (data[tail - 1] == '=') {
            tail--;
        }

        byte[] dest = new byte[tail - data.length / 4];


        // ascii printable to 0-63 conversion
        for (int i = 0; i < data.length; i++) {
            data[i] = base64DecMap[data[i]];
        }

        // 4-byte to 3-byte conversion
        int sidx, didx;
        for (sidx = 0, didx = 0; didx < dest.length - 2; sidx += 4, didx += 3) {
            dest[didx    ] = (byte) (((data[sidx    ] << 2) & 255) | ((data[sidx + 1] >>> 4) & 003));
            dest[didx + 1] = (byte) (((data[sidx + 1] << 4) & 255) | ((data[sidx + 2] >>> 2) & 017));
            dest[didx + 2] = (byte) (((data[sidx + 2] << 6) & 255) | ( data[sidx + 3]        & 077));
        }
        if (didx < dest.length) {
            dest[didx] = (byte) (((data[sidx    ] << 2) & 255) | ((data[sidx + 1] >>> 4) & 003));
        }
        if (++didx < dest.length) {
            dest[didx] = (byte) (((data[sidx + 1] << 4) & 255) | ((data[sidx + 2] >>> 2) & 017));
        }

        return dest;
    }

    /** ߡ */
    private Base64() {
    }
}
