[Setup]
AppName={cm:KagetakaName}
AppId=KagetakaBrowser
AppVerName={cm:KagetakaName} {cm:KagetakaVersion}
AppVersion={cm:KagetakaVersion}
AppPublisher={cm:KagetakaProject}
AppPublisherURL={cm:KagetakaURL}
AppSupportURL={cm:KagetakaURL}
AppUpdatesURL={cm:KagetakaURL}
AppMutex=KagetakaBrowserAppMutex,Global\KagetakaBrowserAppMutex
DefaultDirName={reg:HKCU\Software\kagetaka.org\kagetaka,InstallDir|{pf}\Kagetaka}
DefaultGroupName=.
DisableProgramGroupPage=yes
UninstallDisplayIcon={cm:KagetakaPath}
LicenseFile=COPYING
OutputBaseFilename=@package.file@
OutputDir=.
Compression=lzma/ultra
SolidCompression=yes
VersionInfoCompany=@kagetaka.team@
VersionInfoDescription=@kagetaka.name@
VersionInfoTextVersion=@kagetaka.version@
;VersionInfoVersion=@kagetaka.version@

[Languages]
Name: en; MessagesFile: "compiler:Languages\Default.isl"
Name: ja; MessagesFile: "compiler:Languages\Japanese.isl"

[Files]
Source: "*"                       ; DestDir: "{app}"              ; Excludes: "*.iss"; Flags: ignoreversion
Source: "bin\*.exe"               ; DestDir: "{app}\bin"          ; Flags: ignoreversion
Source: "bin\*.bat"               ; DestDir: "{app}\bin"          ; Flags: ignoreversion
Source: "bin\*.ico"               ; DestDir: "{app}\bin"          ; Flags: ignoreversion
Source: "bin\IEWrapper.dll"       ; DestDir: "{app}\bin"          ; Flags: ignoreversion regserver
Source: "jet\*.prj"               ; DestDir: "{app}\jet"          ; Flags: ignoreversion
Source: "jet\*.bat"               ; DestDir: "{app}\jet"          ; Flags: ignoreversion
Source: "lib\kagetaka-browser.jar"; DestDir: "{app}\lib"          ; Flags: ignoreversion
Source: "docs\*"                  ; DestDir: "{app}\docs"         ; Excludes: "\api"; Flags: ignoreversion recursesubdirs
Source: "sample\themes\*"         ; DestDir: "{app}\sample\themes"; Flags: ignoreversion recursesubdirs

[Icons]
Name: "{group}\{cm:KagetakaName}"                           ; Filename: "{app}\{cm:KagetakaPath}"; WorkingDir: "{app}"; Parameters: "{cm:KagetakaParameters}"
Name: "{userdesktop}\{cm:KagetakaName}"                     ; Filename: "{app}\{cm:KagetakaPath}"; WorkingDir: "{app}"; Parameters: "{cm:KagetakaParameters}"; Tasks: desktopicon
Name: "{userappdata}\{cm:QuickLaunchPath}\{cm:KagetakaName}"; Filename: "{app}\{cm:KagetakaPath}"; WorkingDir: "{app}"; Parameters: "{cm:KagetakaParameters}"; Tasks: quicklaunchicon

[InstallDelete]
Type: filesandordirs; Name: "{app}\docs"

[Registry]
Root: HKCU; Subkey: "Software\kagetaka.org"; Flags: uninsdeletekeyifempty
Root: HKCU; Subkey: "Software\kagetaka.org\kagetaka"; Flags: uninsdeletekey
Root: HKCU; Subkey: "Software\kagetaka.org\kagetaka"; ValueType: string; ValueName: "InstallDir"; ValueData: "{app}"

[Tasks]
Name: "desktopicon"    ; Description: "{cm:CreateDesktopIcon}"    ; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Run]
Filename: "{app}\{cm:KagetakaPath}"; Parameters: "{cm:KagetakaParameters}"; Description: "{cm:LaunchProgram}"; Flags: nowait postinstall skipifsilent

[CustomMessages]
KagetakaVersion=@kagetaka.version@
KagetakaName=@kagetaka.name@
ja.KagetakaName=e
KagetakaProject=@kagetaka.team@
ja.KagetakaProject=evWFNg
KagetakaURL=@kagetaka.url@
KagetakaPath=bin\kagetaka.exe
KagetakaParameters=-J-Xmx128m

AdditionalIcons=Additional icons:
ja.AdditionalIcons=ACR̒ǉ:
CreateDesktopIcon=Create a &desktop icon
ja.CreateDesktopIcon=fXNgbvɃACR쐬(&D)
CreateQuickLaunchIcon=Create a &Quick Launch icon
ja.CreateQuickLaunchIcon=NCbN`ɃACR쐬(&Q)
QuickLaunchPath=Microsoft\Internet Explorer\Quick Launch
LaunchProgram=Launch Kagetaka Browser
ja.LaunchProgram=euEUN

