/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
#include "global.h"
#include "guid.h"
#include "Listener.h"

CListener::CListener()
{
	m_WebBrowser2 = NULL;

	m_ObjRefCount = 1;
	g_DllRefCount++;
}

CListener::~CListener() {
	g_DllRefCount--;
}

// IUnknown Implementation
STDMETHODIMP CListener::QueryInterface(REFIID riid, LPVOID* ppReturn) {
	*ppReturn = NULL;

	// IUnknown
	if (IsEqualIID(riid, IID_IUnknown)) {
		*ppReturn = this;
	} else
	// IOleCommandTarget
	if (IsEqualIID(riid, IID_IOleCommandTarget)) {
		*ppReturn = (IOleCommandTarget*)this;
	} else
	// IObjectWithSite
	if (IsEqualIID(riid, IID_IObjectWithSite)) {
		*ppReturn = (IObjectWithSite*)this;
	}

	if (*ppReturn) {
		(*(LPUNKNOWN*)ppReturn)->AddRef();
		return S_OK;
	}

	return E_NOINTERFACE;
}

STDMETHODIMP_(DWORD) CListener::AddRef() {
	return ++m_ObjRefCount;
}

STDMETHODIMP_(DWORD) CListener::Release() {
	if (--m_ObjRefCount == 0) {
		delete this;
		return 0;
	}

	return m_ObjRefCount;
}

// IOleCommandTarget Implementation
STDMETHODIMP CListener::QueryStatus(const GUID* pguidCmdGroup,
                                    ULONG cCmds,
                                    OLECMD prgCmds[],
                                    OLECMDTEXT* pCmdText) {
	int i;

	for (i = 0; i < (int)cCmds; i++) {
/*
TCHAR szWork[512];
wsprintf(szWork, "%d=[%d,%d]", i, prgCmds[i].cmdID, prgCmds[i].cmdf);
MessageBox(NULL, szWork, "QueryStatus", MB_OK);
*/
		// prgCmds[i].cmdID ̒l̈Ӗs...
//		if (prgCmds[i].cmdID >= 0x2000) {
			LPTSTR szLocationURL;

			prgCmds[i].cmdf = 0;
			if (pCmdText != NULL) {
				pCmdText[i].cmdtextf = OLECMDTEXTF_NONE;
			}

			if (GetLocationURL(&szLocationURL)) {
				if (IsValidURL(szLocationURL)) {
					prgCmds[i].cmdf = OLECMDF_ENABLED;
				}
				delete[] szLocationURL;
			}

//		}
	}

	return S_OK;
}

STDMETHODIMP CListener::Exec(const GUID* pguidCmdGroup,
                             DWORD nCmdID,
                             DWORD nCmdExecOpt,
                             VARIANTARG* pvaIn,
                             VARIANTARG* pvaOut) {
	return SendTo();
}

// IObjectWithSite implementations
STDMETHODIMP CListener::SetSite(IUnknown* punkSite) {

	if (m_WebBrowser2) {
		m_WebBrowser2->Release();
		m_WebBrowser2 = NULL;
	}

	if (punkSite) {
		HRESULT           result              = S_OK;
		IServiceProvider* pServiceProvider    = NULL;
		IServiceProvider* pTopServiceProvider = NULL;

		// Query ServiceProvider
		if (!SUCCEEDED(punkSite->QueryInterface(IID_IServiceProvider, (LPVOID*)&pServiceProvider))) {
			result =  E_FAIL;
			goto CLEANUP;
		}

		// Query Top level ServiceProvider
		if (!SUCCEEDED(pServiceProvider->QueryService(SID_STopLevelBrowser, IID_IServiceProvider, (LPVOID*)&pTopServiceProvider))) {
			result =  E_FAIL;
			goto CLEANUP;
		}

		// Query WebBrowser2
		if (!SUCCEEDED(pTopServiceProvider->QueryService(SID_SWebBrowserApp, IID_IWebBrowser2, (LPVOID*)&m_WebBrowser2))) {
			result =  E_FAIL;
			goto CLEANUP;
		}

CLEANUP:
		if (pTopServiceProvider) {
			pTopServiceProvider->Release();
		}
		if (pServiceProvider) {
			pServiceProvider->Release();
		}

		return result;
	}

	return S_OK;
}

STDMETHODIMP CListener::GetSite(REFIID riid, LPVOID* ppvReturn) {
	return E_NOTIMPL;
}

// private
HRESULT CListener::SendTo() {

	LPTSTR szLocationURL;

	if (!GetLocationURL(&szLocationURL)) {
		return S_OK;
	}

	if (IsValidURL(szLocationURL)) {
		TCHAR path[MAX_PATH];
		DWORD length = MAX_PATH;
		TCHAR command[MAX_PATH * 2 + 5];

		if (GetKagetakaDir(path, &length)) {
			strcat(path, "\\bin\\kagetaka.exe");
			STARTUPINFO         si;
			PROCESS_INFORMATION pi;

			wsprintf(command, "\"%s\" \"%s\"", path, szLocationURL);

			FillMemory(&si, sizeof(si), 0);
			si.cb          = sizeof(si);
			si.dwFlags     = STARTF_USESHOWWINDOW;
			si.wShowWindow = SW_SHOW;
			CreateProcess(path, command, NULL, NULL, FALSE,
			              CREATE_DEFAULT_ERROR_MODE | CREATE_NEW_PROCESS_GROUP,
			              NULL, NULL, &si, &pi);
		}
	}

	delete[] szLocationURL;

	return S_OK;
}

BOOL CListener::GetLocationURL(LPTSTR* url) {

	*url = NULL;

	if (m_WebBrowser2) {
		BSTR bszLocationURL;

		// Get Location URL
		if (m_WebBrowser2->get_LocationURL(&bszLocationURL) == S_OK) {
			BOOL result;
			int reqSize = WideCharToMultiByte(CP_ACP, WC_COMPOSITECHECK, bszLocationURL, -1, NULL, 0, NULL, NULL);
			if (reqSize) {
				*url = new TCHAR[reqSize];
				WideCharToMultiByte(CP_ACP, WC_COMPOSITECHECK, bszLocationURL, -1, *url, reqSize, NULL, NULL);
				result = TRUE;
			} else {
				result = FALSE;
			}
			SysFreeString(bszLocationURL);

			return result;
		}
	}

	return FALSE;
}

BOOL CListener::GetKagetakaDir(LPTSTR path, DWORD* length) {
	if (GetRegValue(HKEY_LOCAL_MACHINE, "Software\\kagetaka.org\\kagetaka", "InstallDir", path, length)) {
		return TRUE;
	}
	if (GetRegValue(HKEY_CURRENT_USER , "Software\\kagetaka.org\\kagetaka", "InstallDir", path, length)) {
		return TRUE;
	}

	return FALSE;
}

BOOL CListener::GetRegValue(HKEY hRootKey, LPCTSTR lpszSubKey, LPCTSTR lpszValueName,
                            LPTSTR value, DWORD* length) {
	LRESULT lResult;
	HKEY    hKey;
	DWORD   lpType;

	lResult = RegOpenKeyEx(hRootKey, lpszSubKey, 0, KEY_READ, &hKey);
	if (lResult != ERROR_SUCCESS) {
		return FALSE;
	}

	lResult = RegQueryValueEx(hKey, lpszValueName, 0,
	                          &lpType, (LPBYTE)value, (LPDWORD)length);
	RegCloseKey(hKey);

	if (lpType != REG_SZ) {
		return FALSE;
	}

	return (lResult == ERROR_SUCCESS ? TRUE : FALSE);
}

BOOL CListener::IsValidURL(LPCTSTR szLocationURL) {
	return (   _strnicmp(szLocationURL, "http://" , 7) == 0
			|| _strnicmp(szLocationURL, "https://", 8) == 0
			|| _strnicmp(szLocationURL, "file://" , 7) == 0);
}
