/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
#include <objbase.h> /* use GUID */
#include <initguid.h> /* init GUID */
#include "global.h"
#include "guid.h"
#include "resource.h"

#include "ClassFactory.h"

#include <olectl.h>
#include <shlwapi.h>

typedef struct {
	HKEY   hRootKey;
	LPTSTR szSubKey;                        // TCHAR szSubKey[MAX_PATH];
	LPTSTR lpszValueName;
	LPTSTR szData;                          // TCHAR szData[MAX_PATH];
} DOREGSTRUCT, *LPDOREGSTRUCT;

extern "C" BOOL WINAPI DllMain(HINSTANCE, DWORD, LPVOID);
static BOOL RegisterServer   (CLSID, LPTSTR);
static BOOL RegisterExtBand  (CLSID, CLSID);
static BOOL RegisterCLSID    (CLSID, DOREGSTRUCT[]);
static BOOL UnregisterServer (CLSID);
static BOOL UnregisterExtBand(CLSID);
static BOOL UnregisterCLSID  (CLSID, HKEY, LPCTSTR);
static BOOL ConvertToString  (CLSID, LPTSTR, DWORD);

HINSTANCE  g_hInstance   = NULL;
UINT       g_DllRefCount = 0;


extern "C"
BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved) {

	switch (dwReason) {
	case DLL_PROCESS_ATTACH:
		g_hInstance = (HINSTANCE)hInstance;
		DisableThreadLibraryCalls(hInstance);
		break;
	case DLL_PROCESS_DETACH:
		break;
	}

	return TRUE;
}

STDAPI DllCanUnloadNow(void) {
	return (g_DllRefCount == 0 ? S_OK : S_FALSE);
}

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppReturn)
{
	*ppReturn = NULL;

	if (!IsEqualIID(rclsid, CLSID_IEWrapper)) {
		return CLASS_E_CLASSNOTAVAILABLE;
	}

	CClassFactory* pClassFactory = new CClassFactory(rclsid);
	if (pClassFactory == NULL) {
		return E_OUTOFMEMORY;
	}

	HRESULT hResult = pClassFactory->QueryInterface(riid, ppReturn);
	pClassFactory->Release();

	return hResult;
}

/////////////////////////////////////////////////////////////////////////////
// DllRegisterServer - Adds entries to the system registry

STDAPI DllRegisterServer(void) {
	if (!RegisterServer(CLSID_IEWrapper, TEXT("Simple &Tool Button"))) {
		return SELFREG_E_CLASS;
	}
	if (!RegisterExtBand(CLSID_IEExtensions, CLSID_IEWrapper)) {
		return SELFREG_E_CLASS;
	}

	return TRUE;
}

STDAPI DllUnregisterServer(void)
{
	if (!UnregisterServer(CLSID_IEWrapper)) {
		return SELFREG_E_CLASS;
	}
	if (!UnregisterExtBand(CLSID_IEExtensions)) {
		return SELFREG_E_CLASS;
	}

	return TRUE;
}

static BOOL RegisterServer(CLSID clsid, LPTSTR lpszTitle) {
	DOREGSTRUCT clsidEntries[] = {HKEY_CLASSES_ROOT, TEXT("CLSID\\%s"),                 NULL,                   lpszTitle,
	                              HKEY_CLASSES_ROOT, TEXT("CLSID\\%s\\InprocServer32"), NULL,                   TEXT("%s"),
	                              HKEY_CLASSES_ROOT, TEXT("CLSID\\%s\\InprocServer32"), TEXT("ThreadingModel"), TEXT("Apartment"),
	                              NULL,              NULL,                              NULL,                   NULL};

	return RegisterCLSID(clsid, clsidEntries);
}

static BOOL RegisterExtBand(CLSID extid, CLSID clsid) {
	LPTSTR  szBase = TEXT("Software\\Microsoft\\Internet Explorer\\Extensions\\%s");
	TCHAR   szCLSID[MAX_PATH];
	TCHAR   szButtonText   [30];
	TCHAR   szMenuText     [30];
	TCHAR   szMenuStatusBar[30];
	TCHAR   szHotIcon      [30];
	TCHAR   szIcon         [30];

	if (!ConvertToString(clsid, szCLSID, MAX_PATH)) {
		return FALSE;
	}

	wsprintf(szButtonText   , TEXT("@%%s,-%d"), IDS_BUTTON_LABEL      );
	wsprintf(szMenuText     , TEXT("@%%s,-%d"), IDS_MENU_LABEL        );
	wsprintf(szMenuStatusBar, TEXT("@%%s,-%d"), IDS_DESCRIPTION       );
	wsprintf(szHotIcon      , TEXT("%%s,%d " ), IDI_ICON_KAGETAKA_HOT );
	wsprintf(szIcon         , TEXT("%%s,%d"  ), IDI_ICON_KAGETAKA_WAIT);

	DOREGSTRUCT clsidEntries[] = {HKEY_LOCAL_MACHINE, szBase, TEXT("CLSID"          ), TEXT("{1FBA04EE-3024-11d2-8F1F-0000F87ABD16}"),
	                              HKEY_LOCAL_MACHINE, szBase, TEXT("ClsidExtension" ), szCLSID,
	                              HKEY_LOCAL_MACHINE, szBase, TEXT("Default Visible"), TEXT("Yes"),
	                              HKEY_LOCAL_MACHINE, szBase, TEXT("ButtonText"     ), szButtonText   ,
	                              HKEY_LOCAL_MACHINE, szBase, TEXT("MenuText"       ), szMenuText     ,
	                              HKEY_LOCAL_MACHINE, szBase, TEXT("MenuStatusBar"  ), szMenuStatusBar,
	                              HKEY_LOCAL_MACHINE, szBase, TEXT("HotIcon"        ), szHotIcon      ,
	                              HKEY_LOCAL_MACHINE, szBase, TEXT("Icon"           ), szIcon         ,
	                              NULL              , NULL                                                          ,                              NULL,                   NULL};

	return RegisterCLSID(extid, clsidEntries);
}

static BOOL RegisterCLSID(CLSID clsid, DOREGSTRUCT clsidEntries[]) {
	TCHAR   szCLSID [MAX_PATH];
	TCHAR   szModule[MAX_PATH];
	TCHAR   szSubKey[MAX_PATH];
	HKEY    hKey;
	DWORD   dwDisp;
	LRESULT lResult;
	int     i;

	if (!ConvertToString(clsid, szCLSID, MAX_PATH)) {
		return FALSE;
	}

	GetModuleFileName(g_hInstance, szModule, MAX_PATH);

	for (i = 0; clsidEntries[i].hRootKey; i++) {
		wsprintf(szSubKey, clsidEntries[i].szSubKey, szCLSID);

		lResult = RegCreateKeyEx(clsidEntries[i].hRootKey, szSubKey, 0, NULL,
		                         REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &hKey, &dwDisp);

		if (lResult == ERROR_SUCCESS) {
			if (clsidEntries[i].lpszValueName || clsidEntries[i].szData) {
				TCHAR szData[MAX_PATH];

				wsprintf(szData, clsidEntries[i].szData, szModule);

				lResult = RegSetValueEx(hKey, clsidEntries[i].lpszValueName, 0,
				                        REG_SZ, (LPBYTE)szData, lstrlen(szData) + 1);
			}
			RegCloseKey(hKey);
		} else {
			return FALSE;
		}
	}

	return TRUE;
}

static BOOL UnregisterServer(CLSID clsid) {
	return UnregisterCLSID(clsid,
	                       HKEY_CLASSES_ROOT,
	                       TEXT("CLSID"));
}

static BOOL UnregisterExtBand(CLSID clsid) {
	return UnregisterCLSID(clsid,
	                       HKEY_LOCAL_MACHINE,
	                       TEXT("Software\\Microsoft\\Internet Explorer\\Extensions"));
}

static BOOL UnregisterCLSID(CLSID clsid, HKEY hRootKey, LPCTSTR pSubKey) {
	TCHAR    szCLSID[MAX_PATH];
	HKEY     hKey;
	LRESULT  lResult;

	if (!ConvertToString(clsid, szCLSID, MAX_PATH)) {
		return FALSE;
	}

	lResult = RegOpenKeyEx(hRootKey, pSubKey, 0, KEY_WRITE, &hKey);

	if (lResult == ERROR_SUCCESS) {
		lResult = SHDeleteKey(hKey, szCLSID);
		RegCloseKey(hKey);
	} else {
		return FALSE;
	}

	return TRUE;
}

static BOOL ConvertToString(CLSID clsid, LPTSTR szCLSID, DWORD cbCLSID) {
	LPWSTR  pwszCLSID;

	StringFromIID(clsid, &pwszCLSID);
	if (pwszCLSID) {
#ifdef UNICODE
		lstrcpyn(szCLSID, pwszCLSID, cbCLSID);
#else
		WideCharToMultiByte(CP_ACP, 0, pwszCLSID, -1, szCLSID, cbCLSID, NULL, NULL);
#endif
		CoTaskMemFree(pwszCLSID);
		return TRUE;
	}

	return FALSE;
}
