/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
#include "global.h"
#include "guid.h"
#include "ClassFactory.h"

#include "Listener.h"

CClassFactory::CClassFactory(CLSID clsid) {
	m_clsidObject = clsid;
	m_ObjRefCount = 1;
	g_DllRefCount++;
}

CClassFactory::~CClassFactory() {
	g_DllRefCount--;
}

// IUnknown Implementation
STDMETHODIMP CClassFactory::QueryInterface(REFIID riid, LPVOID* ppReturn) {
	*ppReturn = NULL;

	// IUnknown
	if (IsEqualIID(riid, IID_IUnknown)) {
		*ppReturn = this;
	} else
	// IClassFactory
	if (IsEqualIID(riid, IID_IClassFactory)) {
		*ppReturn = (IClassFactory*)this;
	}

	if (*ppReturn) {
		(*(LPUNKNOWN*)ppReturn)->AddRef();
		return S_OK;
	}

	return E_NOINTERFACE;
}

STDMETHODIMP_(DWORD) CClassFactory::AddRef() {
	return ++m_ObjRefCount;
}

STDMETHODIMP_(DWORD) CClassFactory::Release() {
	if (--m_ObjRefCount == 0) {
		delete this;
		return 0;
	}

	return m_ObjRefCount;
}

STDMETHODIMP CClassFactory::CreateInstance(LPUNKNOWN pUnknown,
                                           REFIID riid,
                                           LPVOID* ppObject) {
	HRESULT hResult = E_FAIL;
	LPVOID  pTemp   = NULL;

	*ppObject = NULL;

	if (pUnknown != NULL) {
		return CLASS_E_NOAGGREGATION;
	}

	if (IsEqualCLSID(m_clsidObject, CLSID_IEWrapper)) {
		CListener* pListener = new CListener();
		if (pListener == NULL) {
			return E_OUTOFMEMORY;
		}
		pTemp = pListener;
	}

	if (pTemp) {
		hResult = ((LPUNKNOWN)pTemp)->QueryInterface(riid, ppObject);
		((LPUNKNOWN)pTemp)->Release();
	}

	return hResult;
}

STDMETHODIMP CClassFactory::LockServer(BOOL) {
	return E_NOTIMPL;
}
