<?xml version="1.0" encoding="euc-jp"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method              ="text"
              encoding            ="euc-jp"
              media-type          ="text/plain"/>

  <xsl:template match="checkstyle">
    <!-- file list -->
    <xsl:for-each select="file">
      <xsl:sort select="@name"/>
      <xsl:if test="count(error) > 0">
        <xsl:apply-templates select="."/>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <!-- file template -->
  <xsl:template match="file">
    <xsl:for-each select="error">&quot;<xsl:value-of select="../@name"/>&quot;:<xsl:value-of select="@line"/>:&quot;<xsl:value-of select="@message"/>&quot;
</xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
