<?xml version="1.0" encoding="euc-jp"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method              ="xml"
              encoding            ="euc-jp"
              omit-xml-declaration="no"
              doctype-public      ="-//W3C//DTD XHTML 1.1//EN"
              doctype-system      ="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
              indent              ="yes"
              media-type          ="text/html"/>
  <xsl:decimal-format decimal-separator ="."
                      grouping-separator="," />

  <xsl:variable name  ="nameEscape"
                select="'src/'"/>
  <xsl:variable name  ="fileCount"
                select="count(checkstyle/file)"/>
  <xsl:variable name  ="errorCount"
                select="count(checkstyle/file/error)"/>

  <xsl:template match="checkstyle">
    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja">
      <head>
        <meta http-equiv="Content-Type" content="text/html; charset=euc-jp" />
        <meta http-equiv="Content-Style-Type" content="text/css" />
        <meta http-equiv="Content-Script-Type" content="text/javascript" />
        <link rel="stylesheet" type="text/css" href="../../../web/public/styles/main.css" />
        <title> : Dev : CheckStyle</title>
        <style type="text/css">
          table.list {
            width: auto;
          }
          /* file name, error description */
          col.filename, col.desc {
            width: 99%;
          }
          /* number column */
          col.files, col.errors, col.line {
            white-space: nowrap;
            text-align: right;
          }
          /* striping */
          tr.a {
            background-color: #ffffff;
          }
          tr.b {
            background-color: #efefef;
          }
        </style>
      </head>
      <body>
        <table class="header" border="0" cellspacing="0"
               summary="åʥӥ">
          <tbody>
            <tr>
              <td class="logo">
                <img src="../../../web/public/images/title.gif" width="54" height="54" alt=""/>
              </td>
              <td class="navi">
                <div>
                  &#160;&#160;<a href="../../../web/public/index.html">HOME</a>
                  &#160;&#160;<a href="../../../web/public/download.html">Download</a>
                  &#160;&#160;<a href="../../../web/public/history.html">History</a>
                  &#160;&#160;<a href="../../../web/public/support.html">Support</a>
                </div>
              </td>
            </tr>
          </tbody>
        </table>
        <h1 class="title" id="top"> - CheckStyle</h1>

        <!-- Summary part -->
        <xsl:apply-templates select="." mode="summary"/>

        <xsl:if test="$errorCount > 0">
          <!-- File List part -->
          <xsl:apply-templates select="." mode="filelist"/>
          <!-- File Detail part -->
          <xsl:apply-templates select="." mode="filedetail"/>
        </xsl:if>

        <!-- footer -->
        <div class="cr">
          Copyright (c) 2003-2004 The Kagetaka Project
        </div>
      </body>
    </html>
  </xsl:template>

  <!-- summary template -->
  <xsl:template match="checkstyle" mode="summary">
    <h2 class="content"></h2>

    <div class="content">
      <table class="list">
        <colgroup>
          <col class="files" />
          <col class="errors"/>
        </colgroup>
        <thead>
          <tr>
            <th>ե</th>
            <th>顼</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <xsl:call-template name="alternated-row"/>
            <td><xsl:value-of select="format-number($fileCount , '#,##0')"/></td>
            <td><xsl:value-of select="format-number($errorCount, '#,##0')"/></td>
          </tr>
        </tbody>
      </table>
    </div>
  </xsl:template>

  <!-- filelist template -->
  <xsl:template match="checkstyle" mode="filelist">
    <h2 class="content">ե</h2>

    <div class="content">
      <table class="list">
        <colgroup>
          <col class="filename"/>
          <col class="errors"  />
        </colgroup>
        <thead>
          <tr>
            <th>ե̾</th>
            <th>顼</th>
          </tr>
        </thead>
        <tbody>
          <xsl:for-each select="file">
            <xsl:sort data-type="number"
                      order    ="descending"
                      select   ="count(error)"/>
  
            <xsl:if test="count(error) > 0">
              <xsl:variable name  ="nameVisible"
                            select="substring-after(translate(@name, '\', '/'), $nameEscape)"/>
              <xsl:variable name  ="errorCount"
                            select="format-number(count(error), '#,##0')"/>
              <tr>
                <xsl:call-template name="alternated-row"/>
                <td><a href="#f-{$nameVisible}"><xsl:value-of select="$nameVisible"/></a></td>
                <td><xsl:value-of select="$errorCount"/></td>
              </tr>
            </xsl:if>
  
          </xsl:for-each>
        </tbody>
      </table>
    </div>
  </xsl:template>

  <!-- filelist template -->
  <xsl:template match="checkstyle" mode="filedetail">
    <h2 class="content">ܺ</h2>

    <div class="content">
      <!-- For each package create its part -->
      <xsl:for-each select="file">
        <xsl:sort select="@name"/>
        <xsl:if test="count(error) > 0">
          <xsl:apply-templates select="."/>
        </xsl:if>
      </xsl:for-each>
    </div>
  </xsl:template>

  <!-- file template -->
  <xsl:template match="file">
    <xsl:variable name  ="nameVisible"
                  select="substring-after(translate(@name, '\', '/'), $nameEscape)"/>
    <dl>
      <dt id="f-{$nameVisible}"><xsl:value-of select="$nameVisible"/></dt>

      <dd>
        <table class="list">
          <colgroup>
            <col class="desc"/>
            <col class="line"/>
          </colgroup>
          <thead>
            <tr>
              <th>顼</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
            <xsl:for-each select="error">
              <tr>
                <xsl:call-template name="alternated-row"/>
                <td><xsl:value-of select="@message"/></td>
                <td><xsl:value-of select="@line"/></td>
              </tr>
            </xsl:for-each>
          </tbody>
        </table>
      </dd>
    </dl>
  </xsl:template>

  <!-- alternated-row template -->
  <xsl:template name="alternated-row">
    <xsl:attribute name="class">
      <xsl:if test="position() mod 2 = 1">a</xsl:if>
      <xsl:if test="position() mod 2 = 0">b</xsl:if>
    </xsl:attribute>
  </xsl:template>
</xsl:stylesheet>
