#!/bin/sh
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is the Kagetaka Libraries.
#
# The Initial Developer of the Original Code is Hizuya Atsuzaki
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

ADD_VMOPTIONS="-Xmx128M"
ADD_CLASSPATH=

## for JAI
#JAIHOME=/opt/java/libs/jai112/lib
#PATH="${JAIHOME}:${PATH}"
#ADD_CLASSPATH="${ADD_CLASSPATH}:${JAIHOME}/jai_core.jar"
#ADD_CLASSPATH="${ADD_CLASSPATH}:${JAIHOME}/jai_codec.jar"
#ADD_CLASSPATH="${ADD_CLASSPATH}:${JAIHOME}/mlibwrapper_jai.jar"


###################################################################

MAINCLASS="net.hizlab.kagetaka.viewer.Loader"
KAGETAKA_LIB=lib/kagetaka-browser.jar

KAGETAKA_FIND=${HOME}/kagetaka:/usr/local/kagetaka:/usr/kagetaka:/opt/kagetaka:/usr/local/share/kagetaka:/usr/share/kagetaka
JAVA_COMMAND=javaw:java:jre:javaw.sh:java.sh

###################################################################
_JAVA_PATH=
_OLD_JAVA=0
_IFS_OLD="${IFS}"
IFS=:

# Check KAGETAKA_HOME
if [ "${KAGETAKA_HOME}" != "" -a ! -r "${KAGETAKA_HOME}/${KAGETAKA_LIB}" ]; then
  KAGETAKA_HOME=
fi

# Find from command line
if [ "${KAGETAKA_HOME}" = "" ]; then
  _CMD_PATH=
  if echo "$0" | grep -q '/'; then
    _CMD_PATH="$0"
  elif [ "${PATH}" != "" ]; then
    for d in ${PATH}
    do
      if [ -x "${d}/$0" ]; then
        _CMD_PATH="${d}/$0"
      fi
    done
  fi

  if [ "${_CMD_PATH}" != "" ]; then
    # If command is symbolic link file.
    while [ -L "${_CMD_PATH}" ]
    do
      _LINK="`ls -l ${_CMD_PATH} | sed 's/^.*-> //'`"
      _CMD_PATH="`dirname ${_CMD_PATH}`/${_LINK}"
    done

    KAGETAKA_HOME="`dirname ${_CMD_PATH}`"
    KAGETAKA_HOME="`dirname ${KAGETAKA_HOME}`"
    if [ ! -r "${KAGETAKA_HOME}/${KAGETAKA_LIB}" ]; then
      KAGETAKA_HOME=
    fi
  fi
fi

# Find from KAGETAKA_FIND
if [ "${KAGETAKA_HOME}" = "" -a "${KAGETAKA_FIND}" != "" ]; then
  for d in ${KAGETAKA_FIND}
  do
    if [ -r "${d}/${KAGETAKA_LIB}" ]; then
      KAGETAKA_HOME="${d}"
      break
    fi
  done
fi

if [ "${KAGETAKA_HOME}" = "" ]; then
  echo "Kagetaka home directory is not found."
  echo "Please set KAGETAKA_HOME environment."
  echo "ex)"
  echo " for sh, bash, ..."
  echo "   KAGETAKA_HOME=/opt/kagetaka; export KAGETAKA_HOME"
  echo " for csh, tcsh, ..."
  echo "   setenv KAGETAKA_HOME /opt/kagetaka"
  exit 1
fi

if [ "${JAVA_HOME}" != "" ]; then
  for c in ${JAVA_COMMAND}
  do
    if [ -x "${JAVA_HOME}/$c" -a -f "${JAVA_HOME}/${c}" ]; then
      _JAVA_PATH="${JAVA_HOME}/${c}"
      break
    fi
  done
  if [ "${_JAVA_PATH}" != "" -a -r "${JAVA_HOME}/lib/classes.zip" ]; then
    _OLD_JAVA=1
  fi
fi
if [ "${_JAVA_PATH}" = "" -a "${PATH}" != "" ]; then
  for d in ${PATH}
  do
    for c in ${JAVA_COMMAND}
    do
      if [ -x "${d}/${c}" ]; then
        _JAVA_PATH="${d}/${c}"
        break 2
      fi
    done
  done
fi

if [ "${_JAVA_PATH}" = "" ]; then
  if which "${JAVA_COMMAND}" > /dev/null 2>&1; then
    _JAVA_PATH="${JAVA_COMMAND}"
  else
    echo "Java virtual machine is not found."
    echo "Please set JAVA_HOME environment."
    echo "ex)"
    echo " for sh, bash, ..."
    echo "   JAVA_HOME=/opt/java_home; export JAVA_HOME"
    echo " for csh, tcsh, ..."
    echo "   setenv JAVA_HOME /opt/java_home"
    exit 1
  fi
fi

IFS=${_IFS_OLD}

# for VM's option
_VMOPTIONS="${ADD_VMOPTIONS}"
while true
do
  case "$1" in
    -J*)
      _VMOPTIONS="${_VMOPTIONS} `echo $1 | cut -b3-`"
      shift
      ;;
    *)
      break
      ;;
  esac
done

# for CLASSPATH
_CLASSPATH="${KAGETAKA_HOME}/lib/kagetaka-browser.jar"
if [ "${ADD_CLASSPATH}" != "" ]; then
  _CLASSPATH="${_CLASSPATH}:${ADD_CLASSPATH}"
fi

# for CLASSPATH's option
if [ "${_OLD_JAVA}" = 0 ]; then
  _CP_OPTION="-cp"
else
  _CP_OPTION="-classpath"
  _CLASSPATH="${JAVA_HOME}/lib/classes.zip:${_CLASSPATH}"
fi

"${_JAVA_PATH}" ${_VMOPTIONS} ${_CP_OPTION} "${_CLASSPATH}" "${MAINCLASS}" "$@"
