/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.SourceFileScanner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.IOException;

/**
 * ץѥƥ꥽ե뤫顢ꥹȥ꥽
 * ե륯饹Ǥ
 *
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1.1.1 $
 */
public class Property2Java extends MatchingTask {
    private static final char NORMAL_CHAR   = 0x20;
    private static final char REPLACE_MARGIN = 10;
    private String encoding  = null;          // 󥳡ǥ̾
    private File   srcDir    = null;          // ץåȥǥ쥯ȥ
    private File   destDir   = null;          // ȥץåȥǥ쥯ȥ
    private String extension = ".java";       // ȥץåȥեγĥ

    private Mapper mapper = null;

    /**
     * ͣΥ󥹥ȥ饯Ǥ
     */
    public Property2Java() {
    }

    /**
     * եΥ󥳡ǥ󥰤ꤷޤ
     *
     * @param  encoding 󥳡ǥ
     */
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    /**
     * Ѵ뤿Υե뤬äƤǥ쥯ȥꤷޤ
     *
     * @param  srcDir ϥեõǥ쥯ȥ
     */
    public void setSrc(File srcDir) {
        this.srcDir = srcDir;
    }

    /**
     * Ѵե¸ǥ쥯ȥꤷޤ
     *
     * @param  destDir ϥե¸ǥ쥯ȥ
     */
    public void setDest(File destDir) {
        this.destDir = destDir;
    }

    /**
     * ѴȤΥե̾γĥҤꤷޤ
     * ꤵƤʤϡĥҡ.javaפѹޤ
     *
     * @param  ext ѴΥե̾γĥ
     */
    public void setExt(String ext) {
        this.extension = ext;
    }

    /**
     * FileNameMapper  (ͥȤ mapper )
     *
     * @return ޥåѡ
     *
     * @throws BuildException ӥɻ㳰
     */
    public Mapper createMapper() throws BuildException {
        if (mapper != null) {
            throw new BuildException("Cannot define more than one mapper", getLocation());
        }

        mapper = new Mapper(getProject());
        return mapper;
    }

    /**
     * Ѵ򳫻Ϥޤ
     *
     * @throws BuildException ӥɻ㳰
     */
    public void execute()
            throws BuildException {
        if (srcDir == null) {
            srcDir = getProject().resolveFile(".");
        }

        if (destDir == null) {
            throw new BuildException("The dest attribute must be set.");
        }

        if (srcDir.equals(destDir) && extension == null && mapper == null) {
            throw new BuildException("The ext attribute or a mapper must be set if"
                                     + " src and dest dirs are the same.");
        }

        FileNameMapper m = null;
        if (mapper == null) {
            if (extension == null) {
                m = new IdentityMapper();
            } else {
                m = new ExtMapper();
            }
        } else {
            m = mapper.getImplementation();
        }

        DirectoryScanner  scanner = getDirectoryScanner(srcDir);
        String[]          files   = scanner.getIncludedFiles();
        SourceFileScanner sfs     = new SourceFileScanner(this);

        files = sfs.restrict(files, srcDir, destDir, m);
        int count = files.length;
        if (count == 0) {
            return;
        }

        log("Converting " + count + " file" + (count != 1 ? "s" : "")
           + " from " + srcDir
           + " to "   + destDir);

        for (int i = 0; i < files.length; i++) {
            convert(files[i], m.mapFileName(files[i])[0]);
        }
    }

    /** ѴԤ */
    private void convert(String srcName, String destName)
            throws BuildException {
        log("converting " + srcName, Project.MSG_VERBOSE);

        String javaclass   = getJavaClassName  (destName);
        String javapackage = getJavaPackageName(destName);

        File srcFile  = new File(srcDir , srcName );
        File destFile = new File(destDir, destName);
        String parentName = destFile.getParent();
        if (parentName != null) {
            File parentFile = new File(parentName);

            if ((!parentFile.exists()) && (!parentFile.mkdirs())) {
                throw new BuildException("cannot create parent directory " + parentName);
            }
        }

        try {
            BufferedReader in  = null;
            PrintWriter    out = null;
            if (encoding != null) {
                in  = new BufferedReader(
                        new InputStreamReader(
                          new FileInputStream(srcFile), encoding));
                out = new PrintWriter(
                        new OutputStreamWriter(
                          new FileOutputStream(destFile), encoding));
            } else {
                in  = new BufferedReader(
                        new InputStreamReader(
                          new FileInputStream(srcFile)));
                out = new PrintWriter(
                        new OutputStreamWriter(
                          new FileOutputStream(destFile)));
            }

            String line = null, key = null, value = null;
            int p = 0;

            out.println("package " + javapackage + ";");
            out.println("");
            out.println("import java.util.ListResourceBundle;");
            out.println("");
            out.println("public class " + javaclass);
            out.println("\textends ListResourceBundle");
            out.println("{");

            if ((p = javaclass.indexOf('_')) > 0) {
                out.println("\tpublic " + javaclass + "()");
                out.println("\t{");
                out.println("\t\tsetParent(new " + javaclass.substring(0, p) + "());");
                out.println("\t}");
            }

            out.println("\t");
            out.println("\tprivate static final Object[][] contents =");
            out.println("\t{");

            READ:
            while ((line = in.readLine()) != null) {
                p = 0;
                while (p < line.length()) {
                    if (line.charAt(p) == '#') {
                        continue READ;
                    }
                    if (line.charAt(p) > NORMAL_CHAR) {
                        break;
                    }
                }

                p = line.indexOf("=");
                if (p == -1) {
                    continue READ;
                }

                key   = line.substring(0,  p).trim();
                value = line.substring(p + 1).trim();

                // äȤø
                value = replace(value, "\\:", ":");
                value = replace(value, "\"", "\\\"");
                value = replace(value, "\\u0022", "\\\"");
                value = replace(value, "\\u005c", "\\\\");
                value = replace(value, "\\u005C", "\\\\");

                out.println("\t\t{\"" + key + "\", \"" + value + "\"},");
            }

            out.println("\t};");
            out.println("\t");
            out.println("\tpublic Object[][] getContents()");
            out.println("\t{");
            out.println("\t\treturn contents;");
            out.println("\t}");
            out.println("}");

            out.flush();
            out.close();
            in.close();

        } catch (IOException e) {
            throw new BuildException("file " + srcFile
                                     + " has error `" + e.toString() + "'");
        }
    }

    /** java 饹̾ */
    private String getJavaClassName(String srcName) {
        int p = srcName.lastIndexOf(".");
        if (p != -1) {
            srcName = srcName.substring(0, p);
        }

        p = srcName.lastIndexOf(File.separator);
        if (p == -1) {
            return srcName;
        }

        return srcName.substring(p + 1);
    }

    /** java ѥå̾ */
    private String getJavaPackageName(String srcName) {
        String baseDir = srcDir.getPath() + File.separator;

        if (srcName.startsWith(baseDir)) {
            srcName = srcName.substring(baseDir.length() + 1);
        }

        int p = srcName.lastIndexOf(File.separator);
        if (p == -1) {
            return srcName;
        }

        srcName = srcName.substring(0, p);
        return srcName.replace(File.separatorChar, '.');
    }

    /** ʸ֤ */
    private String replace(String value, String oldString, String newString) {
        int startPoint = 0, endPoint = 0;

        if ((endPoint = value.indexOf(oldString, startPoint)) >= 0) {
            int length = oldString.length();
            StringBuffer sb = new StringBuffer(value.length() + Math.max((newString.length() - oldString.length()) * REPLACE_MARGIN, 0));

            do {
                sb.append(value.substring(startPoint, endPoint));
                sb.append(newString);
                startPoint = endPoint + length;
            } while ((endPoint = value.indexOf(oldString, startPoint)) >= 0);

            if (value.length() > endPoint) {
                sb.append(value.substring(startPoint));
            }

            return sb.toString();
        }

        return value;
    }

//### ExtMapper
    /** ĥҤ١ˤޥåѡ */
    private final class ExtMapper implements FileNameMapper {
        /** From  */
        public void setFrom(String s) {
        }

        /** To  */
        public void setTo(String s) {
        }

        /** ޥåԥ󥰤ե̾ */
        public String[] mapFileName(String fileName) {
            int lastDot = fileName.lastIndexOf('.');
            return (lastDot >= 0)
                   ? new String[] {fileName.substring(0, lastDot) + extension}
                   : new String[] {fileName + extension};
        }
    }
}
