// $Id: b_id.h,v 1.1.1.1 2002/08/31 04:47:22 fukasawa Exp $

//=============================================================================
/**
 *  @file    b_id.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef B_ID_H
#define B_ID_H

#include "b_value.h"

struct b_id : public b_value
{
    b_id(): b_value() { m_t = ATOM_UINT4; m._ui = 0; }
    b_id(int  id): b_value((UINT)id) {}
    b_id(UINT id): b_value(id) {}
    b_id(const string& s): b_value(s) {}
    b_id(const BCHAR * id): b_value(id) {}
    b_id(const b_id& rhs): b_value((b_value&)rhs) {}
    ~b_id() {
            if (m_t == ATOM_ASCII && m._str != NULL)
                delete m._str;
        }

    bool get(int& rid) {
            if (m_t == ATOM_ASCII) {
                rid = strtol(m._str->c_str(), NULL, 0);
                return false;
            }
            rid = (int)m._ui;
            return true;
        }
    bool get(UINT& rid) {
            if (m_t == ATOM_ASCII) {
                rid = strtoul(m._str->c_str(), NULL, 0);
                return false;
            }
            rid = m._ui;
            return true;
        }
    bool get(string& rid) const {
            if (m_t == ATOM_ASCII) {
                rid = (m._str == NULL) ? _TX("") : *(m._str) ;
            } else {
                BCHAR buf[64];
                _stprintf(buf, _TX("%u"), m._ui);
                rid = buf;
            }
            return true;
        }

    b_id& operator=(int id)     { init((UINT)id); return *this; }
    b_id& operator=(UINT id)    { init(id); return *this; }
    b_id& operator=(string& id) { init(id); return *this; }
    b_id& operator=(const BCHAR * id) {
            init(id);
            return *this;
        }
    b_id& operator=(const b_id& rhs) {
            if (this == &rhs)
                return *this;
            if (m_t == ATOM_ASCII)
                init(*rhs.m._str);
            else
                init(rhs.m._ui);
            return *this;
        }

    friend bool operator==(const b_id& lhs, const b_id& rhs);
    friend bool operator!=(const b_id& lhs, const b_id& rhs) {
            return (! (lhs == rhs));
        }
    friend bool operator<(const b_id& lhs, const b_id& rhs);

//
protected:
    inline void init(const string& v) {
            clean();
            m_t = ATOM_ASCII;
            m_q = v.size();
            m_sz = sizeof(BCHAR);
            m._str = new string(v);
        }
    inline void init(const BCHAR * v) {
            clean();
            m_t = ATOM_ASCII;
            m_sz = sizeof(BCHAR);
            m._str = new string(v);
            m_q = m._str->size();
        }
    inline void init(UINT v) {
            clean();
            m_t = ATOM_UINT4;
            m_q = 1;
            m_sz = sizeof(UINT);
            m._ui = v;
        }
};

inline bool operator==(const b_id& lhs, const b_id& rhs)
{
    if (lhs.m_t == rhs.m_t) {
        if (lhs.m_t == ATOM_UINT4) {
            return (lhs.m._ui == rhs.m._ui);
        } else {
            return (strcmp(lhs.m._str->c_str(), rhs.m._str->c_str()) == 0);
        }
    }
    return false;
}

inline bool operator<(const b_id& lhs, const b_id& rhs)
{
    if (lhs.m_t == rhs.m_t) {
        if (lhs.m_t == ATOM_UINT4) {
            return (lhs.m._ui < rhs.m._ui);
        } else {
            return (strcmp(lhs.m._str->c_str(), rhs.m._str->c_str()) < 0);
        }
    }
    return false;
}

typedef vector<b_id>  b_ids;

struct id_less
{
     bool operator() (const b_id& x, const b_id& y) const { return (x < y); }
};

#endif  /* B_ID_H */
