// $Id: BS2TclInterp.cpp,v 1.1.1.1 2002/08/31 04:47:24 fukasawa Exp $

//=============================================================================
/**
 *  @file    BS2TclInterp.cpp
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#include "beesecs.h"
#include "BS2Interpreter.h"
#include "tcl.h"

BS2Interpreter<Tcl_Interp>::~BS2Interpreter()
{
}

int BS2Interpreter<Tcl_Interp>::printf(const char * fmt, ...)
{
    char buf[12000];
    va_list arglist;

    va_start(arglist, fmt);
    vsprintf(buf, (const char *)fmt, arglist);

    Tcl_AppendResult(m_interp, buf, NULL);
    return 0;
}

int BS2Interpreter<Tcl_Interp>::print(string msg)
{
    Tcl_AppendResult(m_interp, msg.c_str(), NULL);
    return 0;
}
