// $Id: b_objtype.h,v 1.1.1.1 2002/08/31 04:47:22 fukasawa Exp $

//=============================================================================
/**
 *  @file    b_objtype.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef B_OBJTYPE_H
#define B_OBJTYPE_H

#include "b_object.h"
#include "b_attribute.h"
#include "b_specification.h"


//
// ObjType class
//
class BEE_Export b_objtype
{
    friend class b_object;

public:
    b_objtype(const string& name) : m_name(name), m_seed(1) {
            ObjSpec::instance()->add(this);
        }
    b_objtype(const char * name) : m_name(name), m_seed(1) {
            ObjSpec::instance()->add(this);
        }
    virtual ~b_objtype();

    const char * typeName() const { return m_name.c_str(); }
    int   attrSize() const        { return m_attrs.size(); }
    const b_attributes& attrs() const { return m_attrs; }

    // Add new attribute
    int add(b_attribute * attr);

    // Find attribute by name
    const b_attribute * find(const string& name) const;

    // Create object
    b_object * instance(const char * name = NULL);

    // Get all objects
    int allObject(vector<b_object *>& objects);

    void dump() const;

//
protected:
    int makeObjID(string& retid);
    int entry(b_object * obj);
    int remove(b_object * obj);

protected:
    string        m_name;     // ObjType name
    MUTEX_UInt    m_seed;     // ObjID identifier
    b_attributes  m_attrs;    // attribute table
    b_attrMap     m_dict;     // attribute's dictionary
    b_objectMap   m_objs;     // object's dictionary
    
    ACE_Thread_Mutex m_lock;
};


#endif  /* B_OBJTYPE_H */
