// $Id: b_attribute.cpp,v 1.1.1.1 2002/08/31 04:47:22 fukasawa Exp $

//=============================================================================
/**
 *  @file    b_attribute.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "b_attribute.h"
#include "b_objtype.h"
#include "b_object.h"
#include "b_specification.h"
#include "b_attrdata.h"

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
b_attribute::b_attribute(b_objtype& cls, const char * name, int type,
                         size_t size)
        : m_name(name), m_type(type), m_size(size)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "b_attribute::b_attribute");

    switch (type)
    {
    case ATOM_ASCII:   m_init = "";                 break;
    case ATOM_BINARY:  m_init.set((BYTE *)NULL, 0); break;
    case ATOM_BOOLEAN: m_init = false;              break;
    case ATOM_INT1:    m_init = (char)0;            break;
    case ATOM_INT2:    m_init = (short)0;           break;
    case ATOM_INT4:    m_init = (int)0;             break;
    case ATOM_INT8:    m_init = (LONGLONG)0;        break;
    case ATOM_UINT1:   m_init = (BYTE)0;            break;
    case ATOM_UINT2:   m_init = (USHORT)0;          break;
    case ATOM_UINT4:   m_init = (UINT)0;            break;
    case ATOM_UINT8:   m_init = (ULONGLONG)0;       break;
    case ATOM_FLOAT4:  m_init = (float)0.0;         break;
    case ATOM_FLOAT8:  m_init = (double)0.0;        break;
    default:
        break;
    }

    cls.add(this);
}

//-----------------------------------------------------------------------------
// Create instance data of attribute
//-----------------------------------------------------------------------------
b_attrdata * b_attribute::instance(const b_object * obj) const
{
    TRACE_FUNCTION(TRL_LOW, "b_attribute::instance");

    b_attrdata * val = new b_attrdata(obj, this);

    return val;
}

//-----------------------------------------------------------------------------
// Dump
//-----------------------------------------------------------------------------
void b_attribute::dump() const
{
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("  name = %s, "), m_name.c_str()));
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("type = 0x%x, "), m_type));
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("size = %d, "), m_size));
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("position = %d, "), m_position));
    string value;
    m_init.get(value);
    ACE_DEBUG((LM_DEBUG, ACE_TEXT("initval = %s\n"), value.c_str()));
}

