// $Id: BS2SecsMessage.cpp,v 1.1.1.1 2002/08/31 04:47:24 fukasawa Exp $

//=============================================================================
/**
 *  @file    BS2SecsMessage.cpp
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2001 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#include "BS2ListItem.h"
#include "BS2Binary.h"
#include "BS2Message.h"
#include "BS2MessageDictionary.h"
#include "BS2SecsFuncs.h"

#undef INIT_FUNCTION
#define INIT_FUNCTION(p)
// #define DUMP_MESSAGE(p)    ((p)->dump())
#define DUMP_MESSAGE(p)

struct TransactionInfo {
    unsigned int m_trnum;
    bool         m_wait;
};

extern "C" void * secs_message;

/*---------------------------------------------------------------------------*/
/* create secs2 I/O buffer                                                   */
/*---------------------------------------------------------------------------*/
void make_secs2_buffer(myHeader * head, Message * msgPtr)
{
    INIT_FUNCTION("make_secs2_buffer");
    BS2Message * msg = (BS2Message *)msgPtr;
    TransactionInfo * trinf = (TransactionInfo *)head;
    if (trinf == NULL)
    {
        msg->wait((msg->isPrimary()) ? true : false);
    }
    else
    {
        msg->wait((msg->isPrimary() || trinf->m_wait) ? true : false);
        msg->transNum(trinf->m_trnum);
        delete trinf;
    }
    secs_message = (void *)msg;
    return ;
}

/*---------------------------------------------------------------------------*/
/* create secs2 block header                                                 */
/*---------------------------------------------------------------------------*/
myHeader * make_header(unsigned int trnum, int wbit)
{
    INIT_FUNCTION("make_header");

    bool  w_bit = (wbit != 0) ? true : false;
    TransactionInfo * header = new TransactionInfo();
    header->m_trnum = trnum;
    header->m_wait = w_bit;
    return (myHeader *)header;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
extern int ParseStreamFunction(string& sfstr);

int getMessageFormat(MessageFormatInfo * msginfo, char * sfstr)
{
    INIT_FUNCTION("getMessageFormat");
    BS2MessageType * msgtype = NULL;
    int sfnum;
    string sfs = sfstr;

    sfnum = ParseStreamFunction(sfs);
    if (sfnum < 0)
    {
        return -1;
    }
    msgtype = (BS2MessageType *)(BS2MessageDictionary::instance()->search(sfnum));
    if (msgtype == NULL)
    {
        b_printf("Not found stream function number in the Dictionary", sfstr);
        return -1;
    }

    msginfo->m_msg = (Message *)msgtype;
    msginfo->m_topNode = NULL;
    msginfo->m_curNode = NULL;
    msginfo->m_beforeNode = NULL;

    return 0;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_sxxfxx(MessageFormatInfo * msginfo)
{
    INIT_FUNCTION("func_sxxfxx");
    BS2Message * msg = ((BS2MessageType *)msginfo)->factory();

    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
Message * func_sxxfxx_top(MessageFormatInfo * msginfo, Atom * atom)
{
    INIT_FUNCTION("func_sxxfxx_top");
    list<BS2Atom *> atoms;
    atoms.push_back((BS2Atom *)atom);
    BS2Message * msg = ((BS2MessageType *)msginfo)->factory();
    msg->atomToItem(&atoms);

    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
Message * func_sxxfxx_toplist(MessageFormatInfo * msginfo, Atom * atom)
{
    INIT_FUNCTION("func_sxxfxx_toplist");
    list<BS2Atom *> atoms;
    atoms.push_back((BS2Atom *)atom);
    BS2Message * msg = ((BS2MessageType *)msginfo)->factory();
    msg->atomToItem(&atoms);

    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make nobody message                                                       */
/*---------------------------------------------------------------------------*/
Message * func_nobody(UINT sfnum)
{
    INIT_FUNCTION("func_nobody");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }
    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make one item message                                                     */
/*---------------------------------------------------------------------------*/
Message * func_listitem(UINT sfnum, Item * listitem)
{
    INIT_FUNCTION("func_listitem");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }
    if (listitem == NULL)
    {
        BS2ListItem * _root_item = new BS2ListItem;
        msg->add((BS2Item *)_root_item);
    }
    else
        msg->add((BS2Item *)listitem);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make one item message                                                     */
/*---------------------------------------------------------------------------*/
Message * func_item1(UINT sfnum, Item * item)
{
    INIT_FUNCTION("func_item1");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }
    msg->add((BS2Item *)item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make one item and list item message                                       */
/*---------------------------------------------------------------------------*/
Message * func_item2(UINT sfnum, Item * item1, Item * item2)
{
    INIT_FUNCTION("func_item2");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)item1);
    _root_item->add((BS2Item *)item2);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make one item and list item message                                       */
/*---------------------------------------------------------------------------*/
Message * func_item3(UINT sfnum, Item * item1, Item * item2,
                             Item * item3)
{
    INIT_FUNCTION("func_item3");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)item1);
    _root_item->add((BS2Item *)item2);
    _root_item->add((BS2Item *)item3);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make one item and list item message                                       */
/*---------------------------------------------------------------------------*/
Message * func_item4(UINT sfnum, Item * item1, Item * item2,
                             Item * item3, Item * item4)
{
    INIT_FUNCTION("func_item4");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)item1);
    _root_item->add((BS2Item *)item2);
    _root_item->add((BS2Item *)item3);
    _root_item->add((BS2Item *)item4);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make one item and list item message                                       */
/*---------------------------------------------------------------------------*/
Message * func_item5(UINT sfnum, Item * item1, Item * item2,
                             Item * item3, Item * item4, Item * item5)
{
    INIT_FUNCTION("func_item5");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)item1);
    _root_item->add((BS2Item *)item2);
    _root_item->add((BS2Item *)item3);
    _root_item->add((BS2Item *)item4);
    _root_item->add((BS2Item *)item5);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make one item and list item message                                       */
/*---------------------------------------------------------------------------*/
Message * func_il(UINT sfnum, Item * item, Item * listitem)
{
    INIT_FUNCTION("func_il");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)item);
    if (listitem != NULL)
        _root_item->add((BS2Item *)listitem);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make one item and list item message                                       */
/*---------------------------------------------------------------------------*/
Message * func_iil(UINT sfnum, Item * item1, Item * item2, Item * listitem)
{
    INIT_FUNCTION("func_iil");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)item1);
    _root_item->add((BS2Item *)item2);
    if (listitem != NULL)
        _root_item->add((BS2Item *)listitem);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make one item and list item message                                       */
/*---------------------------------------------------------------------------*/
Message * func_iiil(UINT sfnum, Item * item1, Item * item2, Item * item3,
                   Item * listitem)
{
    INIT_FUNCTION("func_iiil");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)item1);
    _root_item->add((BS2Item *)item2);
    _root_item->add((BS2Item *)item3);
    if (listitem != NULL)
        _root_item->add((BS2Item *)listitem);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make one item and list item message                                       */
/*---------------------------------------------------------------------------*/
Message * func_iiiil(UINT sfnum, Item * item1, Item * item2, Item * item3,
                     Item * item4, Item * listitem)
{
    INIT_FUNCTION("func_iiil");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)item1);
    _root_item->add((BS2Item *)item2);
    _root_item->add((BS2Item *)item3);
    _root_item->add((BS2Item *)item4);
    if (listitem != NULL)
        _root_item->add((BS2Item *)listitem);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_ill(UINT sfnum, Item * item, Item * list1, Item * list2)
{
    INIT_FUNCTION("func_ill");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }

    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)item);
    if (list1 != NULL)
        _root_item->add((BS2Item *)list1);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    if (list2 != NULL)
        _root_item->add((BS2Item *)list2);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make one item and list item message                                       */
/*---------------------------------------------------------------------------*/
Message * func_li(UINT sfnum, Item * listitem, Item * item)
{
    INIT_FUNCTION("func_li");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }

    BS2ListItem * _root_item = new BS2ListItem;
    if (listitem != NULL)
        _root_item->add((BS2Item *)listitem);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    _root_item->add((BS2Item *)item);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make one item and list item message                                       */
/*---------------------------------------------------------------------------*/
Message * func_ll(UINT sfnum, Item * listitem1, Item * listitem2)
{
    INIT_FUNCTION("func_ll");
    BS2Message * msg = BS2Message::factory(sfnum);
    if (msg == NULL)
    {
        return NULL;
    }

    BS2ListItem * _root_item = new BS2ListItem;
    if (listitem1 != NULL)
        _root_item->add((BS2Item *)listitem1);
    else
    {
        BS2ListItem * _empty1_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty1_item);
    }
    if (listitem2 != NULL)
        _root_item->add((BS2Item *)listitem2);
    else
    {
        BS2ListItem * _empty2_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty2_item);
    }

    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}


/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s1f0(void)
{
    INIT_FUNCTION("func_s1f0");
    BS2Message * msg = BS2Message::factory(SFCODE(1,0));;

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s1f2(Item * mdln, Item * softrev)
{
    INIT_FUNCTION("func_s1f2");
    BS2Message * msg = BS2Message::factory(SFCODE(1,2));
    BS2ListItem * _root_item = new BS2ListItem;
    if (mdln != NULL && softrev != NULL)
    {
        _root_item->add((BS2Item *)mdln);
        _root_item->add((BS2Item *)softrev);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s1f6(Item *)         /* ??? */
{
    INIT_FUNCTION("func_s1f6");
    BS2Message * msg = NULL;

    BS2Panic("not implemented yet");

    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s1f8(Item *)   /* ???? */
{
    INIT_FUNCTION("func_s1f8");
    BS2Message * msg = NULL;

    BS2Panic("not implemented yet");

    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s1f10(Item *, Item *)  /* ???? */
{
    INIT_FUNCTION("func_s1f10");
    BS2Message * msg = NULL;

    BS2Panic("not implemented yet");

    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s1f13(Item * mdln, Item * softrev)
{
    INIT_FUNCTION("func_s1f13");
    BS2Message * msg = BS2Message::factory(SFCODE(1,13));
    BS2ListItem * _root_item = new BS2ListItem;
    if (mdln != NULL && softrev != NULL)
    {
        _root_item->add((BS2Item *)mdln);
        _root_item->add((BS2Item *)softrev);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s1f14(Item * commack, Item * mdln, Item * softrev)
{
    INIT_FUNCTION("func_s1f14");
    BS2Message * msg = BS2Message::factory(SFCODE(1,14));
    BS2ListItem * _list_item = new BS2ListItem;
    if ((mdln != NULL) && (softrev != NULL))
    {
        _list_item->add((BS2Item *)mdln);
        _list_item->add((BS2Item *)softrev);
    }
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)commack);
    _root_item->add((BS2Item *)_list_item);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s1f19(Item * objtype, Item * objid_list, Item * attrid_list)
{
    INIT_FUNCTION("func_s1f19");
    BS2Message * msg = BS2Message::factory(SFCODE(1,19));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)objtype);
    if (objid_list != NULL)
        _root_item->add((BS2Item *)objid_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }

    if (attrid_list != NULL)
        _root_item->add((BS2Item *)attrid_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }

    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s1f20(Item * attrdata_list, Item * error_list)
{
    INIT_FUNCTION("func_s1f20");
    BS2Message * msg = BS2Message::factory(SFCODE(1,20));
    BS2ListItem * _root_item = new BS2ListItem;

    if (attrdata_list != NULL)
        _root_item->add((BS2Item *)attrdata_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }

    if (error_list != NULL)
        _root_item->add((BS2Item *)error_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s2f27(Item * loc, Item * ppid, Item * mid_list)
{
    INIT_FUNCTION("func_s2f27");
    BS2Message * msg = BS2Message::factory(SFCODE(2,27));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)loc);
    if (ppid != NULL && mid_list != NULL)
    {
        _root_item->add((BS2Item *)ppid);
        _root_item->add((BS2Item *)mid_list);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s4f19(Item * dataid, Item * trjobname, Item * trjob_list)
{
    INIT_FUNCTION("func_s4f19");
    BS2Message * msg = BS2Message::factory(SFCODE(4,19));
    BS2ListItem * _root_item = new BS2ListItem;
    BS2ListItem * tr_jobs = new BS2ListItem;
    tr_jobs->add((BS2Item *)trjobname);
    tr_jobs->add((BS2Item *)trjob_list);
    _root_item->add((BS2Item *)dataid);
    _root_item->add((BS2Item *)tr_jobs);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s4f20(Item * trjobid, Item * tratomic_decl, Item * tr_result)
{
    INIT_FUNCTION("func_s4f20");
    BS2Message * msg = BS2Message::factory(SFCODE(4,20));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)trjobid);
    if (tratomic_decl != NULL)
        _root_item->add((BS2Item *)tratomic_decl);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    if (tr_result != NULL)
        _root_item->add((BS2Item *)tr_result);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s4f27(Item * eqname, Item * trlink, Item * trport,
                     Item * trobjname, Item * trobjtype, Item * trrole,
                     Item * trptnr, Item * trptport, Item * trdir,
                     Item * trtype, Item * trlocation)
{
    INIT_FUNCTION("func_s4f27");
    BS2Message * msg = BS2Message::factory(SFCODE(4,27));
    BS2ListItem * _root_item = new BS2ListItem;
    BS2ListItem * tr_list = new BS2ListItem;
    tr_list->add((BS2Item *)trlink);
    tr_list->add((BS2Item *)trport);
    tr_list->add((BS2Item *)trobjname);
    tr_list->add((BS2Item *)trobjtype);
    tr_list->add((BS2Item *)trrole);
    tr_list->add((BS2Item *)trptnr);
    tr_list->add((BS2Item *)trptport);
    tr_list->add((BS2Item *)trdir);
    tr_list->add((BS2Item *)trtype);
    tr_list->add((BS2Item *)trlocation);
    _root_item->add((BS2Item *)eqname);
    _root_item->add((BS2Item *)tr_list);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s5f5(Item * alid)
{
    INIT_FUNCTION("func_s5f5");
    BS2Item * alidItem = (BS2Item *)alid;
    if (alid == NULL)
    {
        alidItem = BS2Item::factory("ALID");
    }
    BS2Message * msg = (BS2Message *)func_item1(SFCODE(5,5), (Item *)alidItem);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s6f1(Item * trid, Item * smpln, Item * stime, Item * sv_list)
{
    INIT_FUNCTION("func_s6f1");
    BS2Message * msg = BS2Message::factory(SFCODE(6,1));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)trid);
    _root_item->add((BS2Item *)smpln);
    _root_item->add((BS2Item *)stime);
    if (sv_list != NULL)
        _root_item->add((BS2Item *)sv_list);
    else
    {
        BS2Panic("S6F1: No sampling status value !");

        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s6f3(Item * dataid, Item * ceid, Item * senddata_list)
{
    INIT_FUNCTION("func_s6f3");
    BS2Message * msg = BS2Message::factory(SFCODE(6,3));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)dataid);
    _root_item->add((BS2Item *)ceid);
    if (senddata_list != NULL)
        _root_item->add((BS2Item *)senddata_list);
    else
    {
        BS2Panic("S6F3: No Discrete Variable Data !");

        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s6f25(Item * dataid, Item * opid, Item * linkid, Item * rcpspec,
                     Item * rmchgstat, Item * rcpattr_list, Item * rmack_list)
{
    INIT_FUNCTION("func_s6f25");
    BS2Message * msg = BS2Message::factory(SFCODE(6,25));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)dataid);
    _root_item->add((BS2Item *)opid);
    _root_item->add((BS2Item *)linkid);
    _root_item->add((BS2Item *)rcpspec);
    _root_item->add((BS2Item *)rmchgstat);
    _root_item->add((BS2Item *)rcpattr_list);
    _root_item->add((BS2Item *)rmack_list);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s6f30(Item * trid, Item * rpt_list, Item * errcode)
{
    INIT_FUNCTION("func_s6f30");
    BS2Message * msg = BS2Message::factory(SFCODE(6,30));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)trid);
    if (rpt_list != NULL)
        _root_item->add((BS2Item *)rpt_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    _root_item->add((BS2Item *)errcode);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s7f36(Item * mid, Item * ppid, Item * ppbody)
{
    INIT_FUNCTION("func_s7f36");
    BS2Message * msg = BS2Message::factory(SFCODE(7,36));
    BS2ListItem * _root_item = new BS2ListItem;
    if (mid != NULL && ppid != NULL && ppbody != NULL)
    {
        _root_item->add((BS2Item *)mid);
        _root_item->add((BS2Item *)ppid);
        _root_item->add((BS2Item *)ppbody);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s8f2(Item * bpd)
{
    INIT_FUNCTION("func_s8f2");
    BS2Item * bpdItem = (BS2Item *)bpd;
    if (bpd == NULL)
    {
        bpdItem = BS2Item::factory("BPD");
    }
    BS2Message * msg = (BS2Message *)func_item1(SFCODE(8,2), (Item *)bpdItem);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s8f4(Item * epd)
{
    INIT_FUNCTION("func_s8f4");
    BS2Item * epdItem = (BS2Item *)epd;
    if (epd == NULL)
    {
        epdItem = BS2Item::factory("EPD");
    }
    BS2Message * msg = (BS2Message *)func_item1(SFCODE(8,4), (Item *)epdItem);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s12f1(Item * mid, Item * idtyp, Item * fnloc, Item * ffrot,
                     Item * orloc, Item * rpsel, Item * coord_list,
                     Item * dutms, Item * xdies, Item * ydies, Item * rowct,
                     Item * colct, Item * nulbc, Item * prdct, Item * praxi)
{
    INIT_FUNCTION("func_s12f1");
    BS2Message * msg = BS2Message::factory(SFCODE(12,1));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)mid);
    _root_item->add((BS2Item *)idtyp);
    _root_item->add((BS2Item *)fnloc);
    _root_item->add((BS2Item *)ffrot);
    _root_item->add((BS2Item *)orloc);
    _root_item->add((BS2Item *)rpsel);
    if (coord_list != NULL)
        _root_item->add((BS2Item *)coord_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    _root_item->add((BS2Item *)dutms);
    _root_item->add((BS2Item *)xdies);
    _root_item->add((BS2Item *)ydies);
    _root_item->add((BS2Item *)rowct);
    _root_item->add((BS2Item *)colct);
    _root_item->add((BS2Item *)nulbc);
    _root_item->add((BS2Item *)prdct);
    _root_item->add((BS2Item *)praxi);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s12f3(Item * mid, Item * idtyp, Item * mapft, Item * fnloc,
                     Item * ffrot, Item * orloc, Item * praxi, Item * bcequ,
                     Item * nulbc)
{
    INIT_FUNCTION("func_s12f3");
    BS2Message * msg = BS2Message::factory(SFCODE(12,3));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)mid);
    _root_item->add((BS2Item *)idtyp);
    _root_item->add((BS2Item *)mapft);
    _root_item->add((BS2Item *)fnloc);
    _root_item->add((BS2Item *)ffrot);
    _root_item->add((BS2Item *)orloc);
    _root_item->add((BS2Item *)praxi);
    _root_item->add((BS2Item *)bcequ);
    _root_item->add((BS2Item *)nulbc);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s12f4(Item * mid, Item * idtyp, Item * fnloc, Item * orloc,
                     Item * rpsel, Item * coord_list, Item * dutms,
                     Item * xdies, Item * ydies, Item * rowct, Item * colct,
                     Item * prdct, Item * bcequ, Item * nulbc, Item * mlcl)
{
    INIT_FUNCTION("func_s12f4");
    BS2Message * msg = BS2Message::factory(SFCODE(12,4));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)mid);
    _root_item->add((BS2Item *)idtyp);
    _root_item->add((BS2Item *)fnloc);
    _root_item->add((BS2Item *)orloc);
    _root_item->add((BS2Item *)rpsel);
    if (coord_list != NULL)
        _root_item->add((BS2Item *)coord_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    _root_item->add((BS2Item *)dutms);
    _root_item->add((BS2Item *)xdies);
    _root_item->add((BS2Item *)ydies);
    _root_item->add((BS2Item *)rowct);
    _root_item->add((BS2Item *)colct);
    _root_item->add((BS2Item *)prdct);
    _root_item->add((BS2Item *)bcequ);
    _root_item->add((BS2Item *)nulbc);
    _root_item->add((BS2Item *)mlcl);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s13f13(Item * dataid, Item * objspec, Item * tbltyp,
                      Item * tblid, Item * tblcmd, Item * property_list,
                      Item * colhdr_list, Item * elm_list)
{
    INIT_FUNCTION("func_s13f13");
    BS2Message * msg = BS2Message::factory(SFCODE(13,13));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)dataid);
    _root_item->add((BS2Item *)objspec);
    _root_item->add((BS2Item *)tbltyp);
    _root_item->add((BS2Item *)tblid);
    _root_item->add((BS2Item *)tblcmd);
    _root_item->add((BS2Item *)property_list);
    _root_item->add((BS2Item *)colhdr_list);
    if (elm_list != NULL)
        _root_item->add((BS2Item *)elm_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s13f15(Item * dataid, Item * objspec, Item * tbltyp,
                      Item * tblid, Item * tblcmd, Item * colhdr_list,
                      Item * elt_list)
{
    INIT_FUNCTION("func_s13f15");
    BS2Message * msg = BS2Message::factory(SFCODE(13,15));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)dataid);
    _root_item->add((BS2Item *)objspec);
    _root_item->add((BS2Item *)tbltyp);
    _root_item->add((BS2Item *)tblid);
    _root_item->add((BS2Item *)tblcmd);
    if (colhdr_list != NULL)
        _root_item->add((BS2Item *)colhdr_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    if (elt_list != NULL)
        _root_item->add((BS2Item *)elt_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s13f16(Item * tbltyp, Item * tblid, Item * property_list,
                      Item * colhdr_list, Item * elm_list,
                      Item * tblack_list)
{
    INIT_FUNCTION("func_s13f16");
    BS2Message * msg = BS2Message::factory(SFCODE(13,16));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)tbltyp);
    _root_item->add((BS2Item *)tblid);
    _root_item->add((BS2Item *)property_list);
    _root_item->add((BS2Item *)colhdr_list);
    _root_item->add((BS2Item *)elm_list);
    _root_item->add((BS2Item *)tblack_list);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s14f1(Item * objspec, Item * objtype, Item * objid_list,
                     Item * attr_list, Item * attrid_list)
{
    INIT_FUNCTION("func_s14f1");
    BS2Message * msg = BS2Message::factory(SFCODE(14,1));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)objspec);
    _root_item->add((BS2Item *)objtype);
    if (objid_list != NULL)
        _root_item->add((BS2Item *)objid_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    if (attr_list != NULL)
        _root_item->add((BS2Item *)attr_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    if (attrid_list != NULL)
        _root_item->add((BS2Item *)attrid_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}


/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s14f3(Item * objspec, Item * objtype, Item * objid_list,
                     Item * attr_list)
{
    INIT_FUNCTION("func_s14f3");
    BS2Message * msg = BS2Message::factory(SFCODE(14,3));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)objspec);
    _root_item->add((BS2Item *)objtype);
    if (objid_list != NULL)
        _root_item->add((BS2Item *)objid_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    if (attr_list != NULL)
        _root_item->add((BS2Item *)attr_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s14f5(Item * objspec)
{
    INIT_FUNCTION("func_s14f5");
    BS2Message * msg = BS2Message::factory(SFCODE(14,5));
    msg->add((BS2Item *)objspec);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s15f13(Item * dataid, Item * rcpupdt, Item * rcpspec,
                      Item * rcpattr_list, Item * rcpbody)
{
    INIT_FUNCTION("func_s15f13");
    BS2Message * msg = BS2Message::factory(SFCODE(15,13));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)dataid);
    _root_item->add((BS2Item *)rcpupdt);
    _root_item->add((BS2Item *)rcpspec);
    if (rcpattr_list != NULL)
        _root_item->add((BS2Item *)rcpattr_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    if (rcpbody != NULL)
        _root_item->add((BS2Item *)rcpbody);
    else
    {
        BS2Binary * _empty_atom = new BS2Binary;
        BS2Item * _empty_item =  BS2Item::factory("RCPBODY", _empty_atom);
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s15f21(Item * dataid, Item * rcpcmd, Item * rmnsspec,
                      Item * opid, Item * agent, Item * rcpid_list)
{
    INIT_FUNCTION("func_s15f21");
    BS2Message * msg = BS2Message::factory(SFCODE(15,21));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)dataid);
    _root_item->add((BS2Item *)rcpcmd);
    _root_item->add((BS2Item *)rmnsspec);
    _root_item->add((BS2Item *)opid);
    _root_item->add((BS2Item *)agent);
    if (rcpid_list != NULL)
        _root_item->add((BS2Item *)rcpid_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s15f27(Item * dataid, Item * rcpowcode, Item * rcpspec,
                      Item * rcpattr_list, Item * rcpbody)
{
    INIT_FUNCTION("func_s15f27");
    BS2Message * msg = BS2Message::factory(SFCODE(15,27));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)dataid);
    _root_item->add((BS2Item *)rcpowcode);
    _root_item->add((BS2Item *)rcpspec);
    if (rcpattr_list != NULL)
        _root_item->add((BS2Item *)rcpattr_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    _root_item->add((BS2Item *)rcpbody);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s15f37(Item * rmsegspec, Item * objtoken, Item * rmgrnt,
                      Item * opid, Item * rcpid, Item * rmchgtype)
{
    INIT_FUNCTION("func_s15f37");
    BS2Message * msg = BS2Message::factory(SFCODE(15,37));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)rmsegspec);
    _root_item->add((BS2Item *)objtoken);
    _root_item->add((BS2Item *)rmgrnt);
    _root_item->add((BS2Item *)opid);
    _root_item->add((BS2Item *)rcpid);
    _root_item->add((BS2Item *)rmchgtype);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

//---------------------------------------------------------------------------
// make massage 
//---------------------------------------------------------------------------
Message * func_s16f11(Item * dataid, Item * prjobid, Item * carrier_mf,
                      Item * carslot_list, Item * proc_recipe,
                      Item * prprocessstart, Item * prpauseevent)
{
    INIT_FUNCTION("func_s16f11");
    BS2Message * msg = BS2Message::factory(SFCODE(16,11));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)dataid);
    _root_item->add((BS2Item *)prjobid);
    _root_item->add((BS2Item *)carrier_mf);
    if (carslot_list != NULL)
        _root_item->add((BS2Item *)carslot_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    _root_item->add((BS2Item *)proc_recipe);
    _root_item->add((BS2Item *)prprocessstart);
    _root_item->add((BS2Item *)prpauseevent);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

//---------------------------------------------------------------------------
// make massage 
//---------------------------------------------------------------------------
Message * func_s16f13(Item * dataid, Item * prjob_list, Item * proc_recipe,
                      Item * prprocessstart, Item * prpauseevent)
{
    INIT_FUNCTION("func_s16f13");
    BS2Message * msg = BS2Message::factory(SFCODE(16,13));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)dataid);
    if (prjob_list != NULL)
        _root_item->add((BS2Item *)prjob_list);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    _root_item->add((BS2Item *)proc_recipe);
    _root_item->add((BS2Item *)prprocessstart);
    _root_item->add((BS2Item *)prpauseevent);
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Message * func_s17f5(Item * dataid, Item * trid, Item * ceed,
                     Item * rptid_list, Item * trsper, Item * trace_decl)
{
    INIT_FUNCTION("func_s17f5");
    BS2Message * msg = BS2Message::factory(SFCODE(17,5));
    BS2ListItem * _root_item = new BS2ListItem;
    _root_item->add((BS2Item *)dataid);
    _root_item->add((BS2Item *)trid);
    _root_item->add((BS2Item *)ceed);
    _root_item->add((BS2Item *)rptid_list);
    _root_item->add((BS2Item *)trsper);
    if (trace_decl != NULL)
        _root_item->add((BS2Item *)trace_decl);
    else
    {
        BS2ListItem * _empty_item = new BS2ListItem;
        _root_item->add((BS2Item *)_empty_item);
    }
    msg->add((BS2Item *)_root_item);

    DUMP_MESSAGE(msg);
    return (Message *)msg;
}


//
// *** End of File ***
