// $Id: BS2SecsItem.cpp,v 1.1.1.1 2002/08/31 04:47:24 fukasawa Exp $

//=============================================================================
/**
 *  @file    BS2SecsItem.cpp
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2001 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#include "BS2Binary.h"
#include "BS2UInt2.h"
#include "BS2Int4.h"
#include "BS2Int8.h"
#include "BS2List.h"
#include "BS2Array.h"
#include "BS2ListItem.h"
#include "BS2SecsFuncs.h"

#undef INIT_FUNCTION
#define INIT_FUNCTION(p)

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_item_list(Item * listPtr, Item * item)
{
    INIT_FUNCTION("make_item_list");
    BS2ListItem * aList;
    if (listPtr == NULL)
        aList = new BS2ListItem;
    else
        aList = (BS2ListItem *)listPtr;

    if (item != NULL)
        aList->add((const BS2Item *)item);

    return (Item *)aList;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_alid_array(Item * arrayp, Item * item)
{
    INIT_FUNCTION("make_alid_array");
    BS2Item * alidArray;
    BS2Item * alidItem;
    if (arrayp == NULL)
    {
        return item;
    }
    else
    {
        alidArray = (BS2Item *)arrayp;
        alidItem = (BS2Item *)item;
        alidArray->BS2Item::add(alidItem->atom());
        delete alidItem;
    }
    return (Item *)alidArray;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_item(char * iname, Atom * atom)
{
    INIT_FUNCTION("make_item");
    BS2Item * item = BS2Item::factory(iname, (BS2Atom *)atom);

    return (Item *)item;
}

/*---------------------------------------------------------------------------*/
/* make rsinf array                                                          */
/*---------------------------------------------------------------------------*/
Item * make_rsinf_xyd(int rsinfx, int rsinfy, int rsinfd)
{
    INIT_FUNCTION("make_rsinf");
    BS2Int4Array * atom = new BS2Int4Array;
    atom->add(rsinfx);
    atom->add(rsinfy);
    atom->add(rsinfd);
    BS2Item * item = BS2Item::factory(_T("RSINF"), (BS2Atom *)atom);

    return (Item *)item;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_xypos(int xpos, int ypos)
{
    INIT_FUNCTION("make_xypos");
    BS2Int4Array * atom = new BS2Int4Array;
    atom->add(xpos);
    atom->add(ypos);
    BS2Item * item = BS2Item::factory(_T("XYPOS"), (BS2Atom *)atom);

    return (Item *)item;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_xypos_ll(LONGLONG xpos, LONGLONG ypos)
{
    INIT_FUNCTION("make_xypos_ll");
    BS2Int8Array * atom = new BS2Int8Array;
    atom->add(xpos);
    atom->add(ypos);
    BS2Item * item = BS2Item::factory(_T("XYPOS"), (BS2Atom *)atom);

    return (Item *)item;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_cepack_list(Atom * cpname, Atom * cepval)
{
    INIT_FUNCTION("make_cepack_list");
    BS2ListItem * item = new BS2ListItem;
    item->add((BS2Item *)cpname);
    item->add((BS2Item *)cepval);

    return (Item *)item;
}


/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_cepval_list(Atom * name, Atom * val)
{
    INIT_FUNCTION("make_cepval_list");
    BS2ListItem * item = new BS2ListItem;
    item->add((BS2Item *)name);
    item->add((BS2Item *)val);

    return (Item *)item;
}

//
// *** End of File ***
