// $Id: terminalCmd.cpp,v 1.5 2003/03/16 14:51:02 fukasawa Exp $

//=============================================================================
/**
 *  @file    terminalCmd.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#ifdef _MSC_VER
#pragma warning(disable: 4786)  // too long identifier
#endif

#include "JGEquipment.h"
#include "JGInfoManager.h"
#include "JGVariable.h"
#include "tclbee.h"

#ifdef _MSC_VER
#include <windows.h>
#endif

// function prototype

/*
 *----------------------------------------------------------------------
 *
 * Gem_terminalCmd --
 *
 *      This procedure is invoked to process the "gem::terminal"
 *      command. See the user documentation for details on what it does.
 *
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      See the user documentation.
 *
 *----------------------------------------------------------------------
 */

    /* ARGSUSED */
int
Gem_terminalCmd(ClientData arg, Tcl_Interp * interp, int objc,
                Tcl_Obj *CONST objv[])
{
    // MELDeviceManager * melmngr;
    static char *gemcmds[] = {
        "view",
        "send",
        "get",
        "recognize",
        NULL
    };
    /*
     * All commands enums below ending in X are compatibility
     */
    enum gemcmds {
        TERM_VIEW,
        TERM_SEND,
        TERM_GET,
        TERM_RECOGNIZE,
    };

    Tcl_Obj * res;
    int  cmdindex, result;
    char * termStr;
    BS2id vid;

    JGEquipment * jyugem = (JGEquipment *)arg;
    JGInfoManager * resmngr = jyugem->getInfoManager();
    JGVariable * hmsg = resmngr->variable("HostMessage");
    if (hmsg == NULL)
    {
        Tcl_AppendResult(interp, "HostMessage did not find.", NULL);
        return TCL_ERROR;
    }
    JGVariable * hrcv = resmngr->variable("HostMessageReceived");
    if (hrcv == NULL)
    {
        Tcl_AppendResult(interp, "HostMessageReceived did not find.", NULL);
        return TCL_ERROR;
    }
    JGVariable * recogize = resmngr->variable("HostMessageRecognition");
    if (recogize == NULL)
    {
        Tcl_AppendResult(interp, "HostMessageRecognition did not find.", NULL);
        return TCL_ERROR;
    }
    JGVariable * tmsg = resmngr->variable("TerminalMessage");
    if (tmsg == NULL)
    {
        Tcl_AppendResult(interp, "TerminalMessage did not find.", NULL);
        return TCL_ERROR;
    }
    JGVariable * sendreq = resmngr->variable("TerminalMessageSend");
    if (sendreq == NULL)
    {
        Tcl_AppendResult(interp, "TerminalMessageSend did not find.", NULL);
        return TCL_ERROR;
    }

    Tcl_ResetResult(interp);
    result = TCL_OK;

    if (objc < 2) {
        Tcl_WrongNumArgs(interp, 1, objv, "terminal");
        return TCL_ERROR;
    }
    /*
     * Get the command name index from the object based on the spoolcmds
     * defined above.
     */
    if (Tcl_GetIndexFromObj(interp,
        objv[1], (const char **)gemcmds, "terminal", TCL_EXACT, &cmdindex) != TCL_OK)
        return TCL_ERROR;

    res = NULL;
    switch ((enum gemcmds)cmdindex) {
    case TERM_VIEW:
        {
            string hmsgStr;
            hmsg->getv().get(hmsgStr);
            res = Tcl_NewStringObj(hmsgStr.c_str(), -1);
        }
        break;
    case TERM_SEND:
        {
            termStr = Tcl_GetStringFromObj(objv[2], NULL);
            BS2value text = termStr;
            tmsg->setv(text);

            BS2value pulse = (bool)true;
            sendreq->setv(pulse);              // Set switch
        }
        break;
    case TERM_GET:
        {
            string receivedStr;
            string recognizeStr;
            string sendreqStr;
            hrcv->getv().get(receivedStr);
            recogize->getv().get(recognizeStr);
            sendreq->getv().get(sendreqStr);
            char buf[256];
            sprintf(buf, "%s %s %s", receivedStr.c_str(), recognizeStr.c_str(),
                                     sendreqStr.c_str());
            res = Tcl_NewStringObj(buf, -1);
        }
        break;
    case TERM_RECOGNIZE:
        {
            BS2value pulse = (bool)true;
            recogize->setv(pulse);              // Set switch
        }
        break;

    }

    /*
     * For each different arg call different function to create
     * new commands (or if version, get/return it).
     */
    if (result == TCL_OK && res != NULL)
        Tcl_SetObjResult(interp, res);

    return TCL_OK;
}

