// $Id: DBAlarmElm.h,v 1.4 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBAlarmElm.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef DBALARMELM_H
#define DBALARMELM_H

#include "dbio.h"
#include "JGAlarm.h"

class JGEquipment;

// Define an object to hold configure data
class DBAlarmElm : public JGAlarm
{
public:
    DBAlarmElm() : JGAlarm() {}
    DBAlarmElm(const JGAlarm& rhs) : JGAlarm(rhs) {}
    DBAlarmElm& operator=(const JGAlarm& rhs) {
            if (this == &rhs) return *this;
            *((JGAlarm *)this) = rhs;
            return *this;
        }

    friend class dtl::DefaultBCA<DBAlarmElm>;
    friend class dtl::DefaultInsValidate<DBAlarmElm>;
    friend class dtl::DefaultSelValidate<DBAlarmElm>;
    friend class UPDAlarmElm;

    friend bool operator<(const DBAlarmElm &val1, const DBAlarmElm &val2)
    {
        return (val1.m_id < val2.m_id);
    }

    static void load(JGEquipment * equip);
    static void save(JGEquipment * equip);
    static int  update(JGEquipment * equip, JGid& vid);
    int formdb();

protected:
    string m_alidStr;
    string m_vidStr;
    string m_almstatusStr;
    string m_enabledStr;
};

//
// Define an object to hold alarm code data
//
class DBAlcdElm : public JGAlcd
{
public:
    DBAlcdElm() : JGAlcd() { }
    DBAlcdElm(const JGAlcd& rhs) : JGAlcd(rhs) {}
    DBAlcdElm& operator=(const JGAlcd& rhs) {
            if (this == &rhs) return *this;
            *((JGAlcd *)this) = rhs;
            return *this;
        }

    const BCHAR * operatorStr()  { return m_operatorStr.c_str(); }
    const BCHAR * equipmentStr() { return m_equipmentStr.c_str(); }
    const BCHAR * materialStr()  { return m_materialStr.c_str(); }

    friend class dtl::DefaultBCA<DBAlcdElm>;
    friend class dtl::DefaultInsValidate<DBAlcdElm>;
    friend class dtl::DefaultSelValidate<DBAlcdElm>;

    friend bool operator<(const DBAlcdElm &val1, const DBAlcdElm &val2)
    {
        return (val1.m_alcd < val2.m_alcd);
    }

protected:
    string m_operatorStr;
    string m_equipmentStr;
    string m_materialStr;
};

// Updata element
class UPDAlarmElm
{
public:
    void operator()(BoundIOs &boundIOs, DBAlarmElm &rowbuf)
    {
        boundIOs["ENABLED"] == rowbuf.m_enabledStr;
    }
};


// Create an association between table columns and fields in our object
// Here, BoundIOs is a class that is passed in to store column names &
// mappings

BEGIN_DTL_NAMESPACE

template<> class DefaultBCA<DBAlarmElm>
{
public:
    void operator()(BoundIOs &cols, DBAlarmElm &row)
    {
        cols[_TX("ALID")] == row.m_alidStr;
        cols[_TX("ALTX")] == row.m_altx;
        cols[_TX("ALM_STATUS")] == row.m_almstatusStr;
        cols[_TX("ENABLED")] == row.m_enabledStr;
        cols[_TX("ALCD")] == row.m_alcd;
        cols[_TX("DISPOSAL")] == row.m_disposal;
        cols[_TX("VID")] == row.m_vidStr;
    }
};

// Specialization of DefaultInsValidate for DBAlarmElm
// This defines a business rule we wish to enforce for all
// DBAlarmElm objects before they are allowed to be inserted into the database
template<> class DefaultInsValidate<DBAlarmElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBAlarmElm &rowbuf) {
        // data is valid if rowbuf.m_alid is nonempty and
        // rowbuf.m_altx is nonempty
        return (!rowbuf.m_id.isNil() && rowbuf.m_altx.length() > 0);
    }
};

template<> class DefaultSelValidate<DBAlarmElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBAlarmElm &rowbuf) {
        return true;
    }
};

// Parameter for update
template<> class DefaultParamObj<DBAlarmElm>
{
public:
    string m_alidStr;
};

template<> class DefaultBPA<DefaultParamObj<DBAlarmElm> >
{
public:
    void operator()(BoundIOs &boundIOs, DefaultParamObj<DBAlarmElm> &paramObj)
    {
      boundIOs[0] == paramObj.m_alidStr;
    }
};

//
// Alarm Code
//
template<> class DefaultBCA<DBAlcdElm>
{
public:
    void operator()(BoundIOs &cols, DBAlcdElm &row)
    {
        cols[_TX("ALCD")] == row.m_alcd;
        cols[_TX("ALCD_TEXT")] == row.m_alcd_text;
        cols[_TX("DANGER")] == row.m_danger;
        cols[_TX("AF_OPERATOR")] == row.m_operatorStr;
        cols[_TX("AF_EQUIPMENT")] == row.m_equipmentStr;
        cols[_TX("AF_MATERIAL")] == row.m_materialStr;
    }
};

// Specialization of DefaultInsValidate for DBAlcdElm
// This defines a business rule we wish to enforce for all
// DBAlcdElm objects before they are allowed to be inserted into the database
template<> class DefaultInsValidate<DBAlcdElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBAlcdElm &rowbuf) {
        return true;
    }
};

template<> class DefaultSelValidate<DBAlcdElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBAlcdElm &rowbuf) {
        return true;
    }
};


END_DTL_NAMESPACE

#endif  /* DBALARMELM_H */
