// $Id: JGStateTask.cpp,v 1.2 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGStateTask.cpp
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGTrigger.h"
#include "JGStateTask.h"
#include "BS2Message.h"

RootState JGStateTask::Root(STATE_ROOT);

//-----------------------------------------------------------------------------
// Trigger Request
//-----------------------------------------------------------------------------
int JGStateTask::ChangeStateRequest::call()
{
    TRACE_FUNCTION(TRL_LOW, "JGStateTask::ChangeStateRequest::call");

    JGStateTask * stask = (JGStateTask *)m_task;
    stask->accept(m_trigger);
    return 0;
}

//-----------------------------------------------------------------------------
// Initialize .
//-----------------------------------------------------------------------------
int JGStateTask::init(void * parm)
{
    TRACE_FUNCTION(TRL_LOW, "JGStateTask::init");
    ACE_UNUSED_ARG(parm);

    this->initTransitions();         // transitions must be initialized

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Open a service thread.
//-----------------------------------------------------------------------------
int JGStateTask::open(void * parm)
{
    TRACE_FUNCTION(TRL_LOW, "JGStateTask::open");
    ACE_UNUSED_ARG(parm);

    if (this->activate(THR_NEW_LWP | THR_DETACHED) == -1)
    {
        ACE_ERROR_RETURN((LM_ERROR, "%p\n", "spawn"), -1);
    }
    m_thread = true;
    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Close .
//-----------------------------------------------------------------------------
int JGStateTask::close(int flag)
{
    TRACE_FUNCTION(TRL_LOW, "JGStateTask::close");
    ACE_UNUSED_ARG(flag);

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Call service thread.
//-----------------------------------------------------------------------------
int JGStateTask::notify(JGStateTask::ChangeStateRequest * req)
{
    TRACE_FUNCTION(TRL_LOW, "JGStateTask::notify");
    if (m_thread)
    {
        return m_activation_queue.enqueue(req);
    }
    else
    {
        req->call();
        delete req;
        return 0;
    }
}


//-----------------------------------------------------------------------------
// Receive message thread. (Not Use)
//-----------------------------------------------------------------------------
int JGStateTask::svc(void)
{
    int result = 0;

    // Receive trigger request.
    for (;;)
    {
        auto_ptr<ACE_Method_Request> mo(this->m_activation_queue.dequeue());

        ACE_DEBUG((LM_DEBUG, ACE_TEXT("[%s] calling method request\n"),
                             this->charName()));
        // Call it.
        if ((result = mo->call()) == -1)
        {
            break;
        }

        // Destructor automatically deletes it.
    }

    if (result == -1 && errno == EWOULDBLOCK)
    {
        ACE_ERROR((LM_ERROR,
              ACE_TEXT("(%t) %p\n"), "timed out waiting for message"));
    }

    ACE_DEBUG((LM_DEBUG, ACE_TEXT("(%t) JGStateTask::svc end.\n")));
    return 0;
}


