// $Id: JGClass.cpp,v 1.3 2003/02/28 14:44:50 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGClass.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGClass.h"
#include "JGObject.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"

static b_attribute _attrObjType(_TX("ObjType"), ATOM_ASCII, 256);
static b_attribute _attrObjID(_TX("ObjID"), ATOM_ASCII, 256);

//-----------------------------------------------------------------------------
// Initial base class.
//-----------------------------------------------------------------------------
int JGClass::initBase()
{
    TRACE_FUNCTION(TRL_LOW, "JGClass::initBase");

    this->add(&_attrObjType);
    this->add(&_attrObjID);

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Create ObjType Item (for S14F6)
//-----------------------------------------------------------------------------
BS2Item * JGClass::getObjType()
{
    TRACE_FUNCTION(TRL_LOW, "JGClass::getObjType");

    BS2Atom * atom = new BS2Ascii(m_name);
    BS2Item * item = BS2Item::factory(_TX("OBJTYPE"), atom);

    return item;

}

//-----------------------------------------------------------------------------
// Create Attribute Name Item (for S14F8)
//-----------------------------------------------------------------------------
BS2Item * JGClass::getAttrName()
{
    TRACE_FUNCTION(TRL_LOW, "JGClass::getAttrName");
    BS2ListItem * listitem = new BS2ListItem;
    BS2ListItem * attrlist = new BS2ListItem;
    BS2Atom * atom = new BS2Ascii(m_name);
    BS2Item * item = BS2Item::factory(_TX("OBJTYPE"), atom);
    listitem->add(item);
    for (size_t i = 0; i < m_attrs.size(); i++)
    {
        atom = new BS2Ascii(m_attrs[i]->name());
        item = BS2Item::factory(_TX("ATTRID"), atom);
        attrlist->add(item);
    }
    listitem->add(attrlist);
    return listitem;
}

//-----------------------------------------------------------------------------
// Dump
//-----------------------------------------------------------------------------
void JGClass::dump() const
{
    this->b_objtype::dump();
}


