// $Id: JGAttrData.h,v 1.5 2003/02/02 15:59:25 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGAttrData.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGATTRDATA_H
#define JGATTRDATA_H

#include "jyugem.h"

class JGClass;
class JGObject;
class JGAttribute;
class BS2Item;
class BS2Atom;

//
// Attribute Data Class
//
class BEE_Export JGAttrData : public b_attrdata
{
    friend class JGAttribute;
    friend class JGVector;
    friend class JGStruct;

public:
    JGAttrData(const JGAttrData& rhs) : b_attrdata(rhs) {}
    ~JGAttrData() {}

    JGAttrData& operator=(const JGAttrData& rhs) {
            if (this == &rhs)
                return *this;
            this->b_attrdata::operator=(rhs);
            return *this;
        }

    const JGObject * getObject() const {
            return reinterpret_cast<const JGObject *>(m_obj);
        }
    const JGAttribute * getAttribute() const {
            return reinterpret_cast<const JGAttribute *>(m_attr);
        }

    JGAttribute * attribute() {
        return const_cast<JGAttribute *>(reinterpret_cast<const JGAttribute *>(m_attr));
    }
    JGObject * object() {
        return const_cast<JGObject *>(reinterpret_cast<const JGObject *>(m_obj));
    }
    JGClass * objtype() {
        return const_cast<JGClass *>(reinterpret_cast<const JGClass *>(this->b_attrdata::objtype()));
    }

    // Make SECS Message Item data
    BS2Atom * getAtom();
    BS2Item * getItem();  // "ATTRID" + "ATTRDATA"

protected:
    JGAttrData() : b_attrdata(NULL, NULL) {}
    JGAttrData(JGObject * obj, JGAttribute * attr);
    BS2Item * getVectorItem();
    BS2Item * getStructItem();

// Member variables
protected:
};

#endif  /* JGATTRDATA_H */
