// $Id: JGAttrData.cpp,v 1.6 2003/02/02 15:59:25 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGAttrData.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGAttrData.h"
#include "JGObject.h"
#include "JGAttribute.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
JGAttrData::JGAttrData(JGObject * obj, JGAttribute * attr)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGAttrData::JGAttrData");

    m_obj = obj;
    m_attr = attr;
    if (attr->isStruct())
    {
        b_valvect vv;
        this->b_value::set(vv);
        this->m_t = ATOM_STRUCT;
    }
    else
    {
        this->b_value::set(const_cast<b_value&>(attr->getInitVal()));
    }
}


//-----------------------------------------------------------------------------
// Make SECS Message Item data
//-----------------------------------------------------------------------------
BS2Item * JGAttrData::getItem()
{
    TRACE_FUNCTION(TRL_LOW, "JGAttrData::getItem");

    BS2Item * attritem;
    BS2ListItem * mbrlist = new BS2ListItem;
    BS2Item * attrid = BS2Item::factory(_TX("ATTRID"),
                                        new BS2Ascii(m_attr->name()));
    mbrlist->add(attrid);
    if (m_attr->isVector())
    {
        attritem = getVectorItem();
    }
    else if (m_attr->isStruct())
    {
        attritem = getStructItem();
    }
    else
    {
        attritem = BS2Item::factory(_TX("ATTRDATA"), this->getAtom());
    }
    mbrlist->add(attritem);
    return mbrlist;
}

//-----------------------------------------------------------------------------
// Make SECS Message Item data
//-----------------------------------------------------------------------------
BS2Item * JGAttrData::getVectorItem()
{
    TRACE_FUNCTION(TRL_LOW, "JGAttrData::getVectorItem");

    BS2Item * mbrItem;
    BS2ListItem * mbrlist = new BS2ListItem;

    JGAttribute * mbrAttr = ((JGVector *)m_attr)->member();
    if (mbrAttr->isVector())
    {
        b_valvect * vec = (b_valvect *)m._vec;
        if (vec != NULL || vec->size() > 0)
        {
            int length = vec->size();
            for (int i = 0; i < length; i++)
            {
                JGAttrData * mbrData = reinterpret_cast<JGAttrData *>((*vec)[i]);
                mbrItem = mbrData->getVectorItem();
                mbrlist->add(mbrItem);
            }
        }
    }
    else if (mbrAttr->isStruct())
    {
        b_valvect * vec = (b_valvect *)m._vec;
        if (vec != NULL || vec->size() > 0)
        {
            int length = vec->size();
            for (int i = 0; i < length; i++)
            {
                JGAttrData * mbrData = reinterpret_cast<JGAttrData *>((*vec)[i]);
                mbrItem = mbrData->getStructItem();
                mbrlist->add(mbrItem);
            }
        }
    }
    else
    {
        b_valvect * vec = (b_valvect *)m._vec;
        if (vec != NULL || vec->size() > 0)
        {
            int length = vec->size();
            for (int i = 0; i < length; i++)
            {
                JGAttrData * mbrData = reinterpret_cast<JGAttrData *>((*vec)[i]);
                mbrItem = BS2Item::factory(_TX("ATTRDATA"), mbrData->getAtom());
                mbrlist->add(mbrItem);
            }
        }
    }
    return mbrlist;
}

//-----------------------------------------------------------------------------
// Make SECS Message Item data
//-----------------------------------------------------------------------------
BS2Item * JGAttrData::getStructItem()
{
    TRACE_FUNCTION(TRL_LOW, "JGAttrData::getStructItem");

    BS2Item * mbrItem;
    BS2Item * attrid;
    BS2ListItem * nodelist = new BS2ListItem();

    b_valvect * vec = (b_valvect *)m._vec;
    if (vec != NULL || vec->size() > 0)
    {
        int length = vec->size();
        for (int i = 0; i < length; i++)
        {
            JGAttrData * mbrData = reinterpret_cast<JGAttrData *>((*vec)[i]);
            JGAttribute * mbrAttr = mbrData->attribute();
            BS2ListItem * mbrlist = new BS2ListItem();

            attrid = BS2Item::factory(_TX("ATTRID"),
                                      new BS2Ascii(mbrAttr->name()));
            mbrlist->add(attrid);

            if (mbrAttr->isVector())
            {
                mbrItem = mbrData->getStructItem();
            }
            else if (mbrAttr->isStruct())
            {
                mbrItem = mbrData->getVectorItem();
            }
            else
            {
                mbrItem = BS2Item::factory(_TX("ATTRDATA"), mbrData->getAtom());
            }
            mbrlist->add(mbrItem);
            nodelist->add(mbrlist);
        }
    }
    return nodelist;
}

//-----------------------------------------------------------------------------
// Make Atomic data
//-----------------------------------------------------------------------------
BS2Atom * JGAttrData::getAtom()
{
    TRACE_FUNCTION(TRL_LOW, "JGAttrData::getAtom");
    BS2Atom * atom;

    if ((this->format() == ATOM_LIST) ||
        (this->format() == ATOM_STRUCT) || (this->format() == ATOM_VECTOR))
    {
        BS2List * listatom = new BS2List();
        b_valvect * vec = (b_valvect *)m._vec;
        if (vec == NULL || vec->size() == 0)
        {
            atom = listatom;
        }
        else
        {
            int length = vec->size();
            for (int i = 0; i < length; i++)
            {
                JGAttrData * mbrData = reinterpret_cast<JGAttrData *>((*vec)[i]);
                atom = mbrData->getAtom();
                listatom->add(atom);
            }
            atom = listatom;
        }
    }
    else
    {
        atom = BS2Atom::factory(*this);
    }
    return atom;
}

