// $Id: DBReportElm.h,v 1.3 2003/03/16 14:51:01 fukasawa Exp $

//=============================================================================
/**
 *  @file    DBReportElm.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef DBREPORTELM_H
#define DBREPORTELM_H

#include "dbio.h"
#include "JGReport.h"

class JGEquipment;

// Define an object to hold configure data
class DBReportElm : public JGReport
{
public:
    DBReportElm() : JGReport() { }
    DBReportElm(const JGReport& rhs) : JGReport(rhs) { }
    DBReportElm& operator=(const JGReport& rhs) {
            if (this == &rhs) return *this;
            *((JGReport *)this) = rhs;
            return *this;
        }
    friend class dtl::DefaultBCA<DBReportElm>;
    friend class dtl::DefaultInsValidate<DBReportElm>;
    friend class dtl::DefaultSelValidate<DBReportElm>;

    friend bool operator<(const DBReportElm &val1, const DBReportElm &val2)
    {
        return (val1.m_rptidStr < val2.m_rptidStr);
    }

    static void load(JGEquipment * equip);
    static void save(JGEquipment * equip);
    int formdb();

protected:
    string m_rptidStr;
};


//
// Define an object to hold report data
//
class DBRptDataElm : public JGRptData
{
public:
    DBRptDataElm() : JGRptData() { }

    friend class dtl::DefaultBCA<DBRptDataElm>;
    friend class dtl::DefaultInsValidate<DBRptDataElm>;
    friend class dtl::DefaultSelValidate<DBRptDataElm>;

    friend bool operator<(const DBRptDataElm &val1, const DBRptDataElm &val2)
    {
        return (val1.m_rptidStr < val2.m_rptidStr);
    }

    static void load(JGEquipment * equip);
    static void save(JGEquipment * equip);

protected:
    string m_rptidStr;
    string m_vidStr;
    int    m_seqnum;
};

// Create an association between table columns and fields in our object
// Here, BoundIOs is a class that is passed in to store column names &
// mappings

BEGIN_DTL_NAMESPACE

template<> class DefaultBCA<DBReportElm>
{
public:
    void operator()(BoundIOs &cols, DBReportElm &row)
    {
        cols[_TX("RPTID")] == row.m_rptidStr;
        cols[_TX("RPT_NAME")] == row.m_name;
    }
};

// Specialization of DefaultInsValidate for DBReportElm
// This defines a business rule we wish to enforce for all
// DBReportElm objects before they are allowed to be inserted into the database
template<> class DefaultInsValidate<DBReportElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBReportElm &rowbuf) {
        // data is valid if rowbuf.m_rptid is nonempty and
        // rowbuf.m_rptname is nonempty
        return (rowbuf.m_rptidStr.length() > 0 && rowbuf.m_name.length() > 0);
    }
};

template<> class DefaultSelValidate<DBReportElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBReportElm &rowbuf) {
        return true;
    }
};

//
//
//
template<> class DefaultBCA<DBRptDataElm>
{
public:
    void operator()(BoundIOs &cols, DBRptDataElm &row)
    {
        cols[_TX("RPTID")] == row.m_rptidStr;
        cols[_TX("VID")] == row.m_vidStr;
        cols[_TX("SEQ_NUM")] == row.m_seqnum;
    }
};

// Specialization of DefaultInsValidate for DBRptDataElm
// This defines a business rule we wish to enforce for all
// DBRptDataElm objects before they are allowed to be inserted into the database
template<> class DefaultInsValidate<DBRptDataElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBRptDataElm &rowbuf) {
        // data is valid if rowbuf.m_rptid is nonempty and
        // rowbuf.m_vid is nonempty
        return (rowbuf.m_rptidStr.length() > 0 && rowbuf.m_vidStr.length() > 0);
    }
};

template<> class DefaultSelValidate<DBRptDataElm>
{
public:

    bool operator()(BoundIOs &boundIOs, DBRptDataElm &rowbuf) {
        return true;
    }
};


END_DTL_NAMESPACE

#endif  /* DBREPORTELM_H */
