// $Id: JGSpecification.cpp,v 1.2 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGSpecification.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGSpecification.h"
#include "JGClass.h"
#include "JGObject.h"
#include "JGErrorList.h"
#include "BS2Message.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"

//-----------------------------------------------------------------------------
// Create message/item (for S14F6)
//-----------------------------------------------------------------------------
int JGSpecification::getObjTypes(BS2ListItem * listitem)
{
    TRACE_FUNCTION(TRL_LOW, "JGSpecification::getObjTypes");

    int result = 0;

    // Get object type name in class
    ClassMap::iterator iter = m_classes.begin();
    for ( ; iter != m_classes.end() ; iter++)
    {
        JGClass * cur_class = (JGClass *)((*iter).second);
        BS2Item * item = cur_class->getObjType();
        listitem->add(item);
        result++;
    }

    return result;
}

//-----------------------------------------------------------------------------
// Get All Classes
//-----------------------------------------------------------------------------
int JGSpecification::getAllClasses(vector<JGClass *>& clazzes)
{
    TRACE_FUNCTION(TRL_LOW, "JGSpecification::getAllClasses");

    int result = 0;

    // Get object type name in class
    ClassMap::iterator iter = m_classes.begin();
    for ( ; iter != m_classes.end() ; iter++)
    {
        JGClass * cur_class = (JGClass *)((*iter).second);
        clazzes.push_back(cur_class);
        result++;
    }

    return result;
}

//-----------------------------------------------------------------------------
// Get All Objects
//-----------------------------------------------------------------------------
int JGSpecification::getAllObjects(vector<JGObject *>& objs)
{
    TRACE_FUNCTION(TRL_LOW, "JGSpecification::getAllObjects");

    int result = 0;

    // Get object in specification
    ObjectMap::iterator iter = m_objs.begin();
    for ( ; iter != m_objs.end() ; iter++)
    {
        JGObject * cur_obj = (JGObject *)((*iter).second);
        objs.push_back(cur_obj);
        result++;
    }

    return result;
}
