// $Id: JGObjTraverser.h,v 1.1 2003/02/02 16:21:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGObjTraverser.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGOBJTRAVERSER_H
#define JGOBJTRAVERSER_H

#include "JGObject.h"
#include "JGErrorList.h"
#include "BS2Traverser.h"

class JGManager;
class JGClass;
class JGSpecification;

//
// Parser of SECS Message
//
class JGObjTraverser : public BS2Traverser
{
public:
    JGObjTraverser(JGManager * mngr, JGClass * klass, const BCHAR * ackName,
                   int ackType);
    virtual ~JGObjTraverser() {}

    // Check the Object specification
    int checkObjSpec(BS2Atom * atom);

    // Implementation for object parameters
    virtual int parseItem(BS2Item * item);

    // Deside the position of ID/DATA
    virtual int beginList(BS2ListItem * listitem);
    virtual int endList(BS2ListItem * listitem);

protected:
    JGManager * m_manager;
    JGClass *   m_clazz;
    JGObject *  m_object;
    JGSpecification  * m_env;
    string           m_objspec;
    JGErrorList      m_errs;
    JGObject::Setter m_setter;


};

#endif
