// $Id: JGMateMoveManager.cpp,v 1.3 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGMateMoveManager.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGMateMoveManager.h"
#include "JGEquipment.h"
#include "JGTaskTrigger.h"
#include "JGVariable.h"
#include "BS2ACKMessage.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"

static JGMateMoveManager * _manager = NULL;

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
JGMateMoveManager::JGMateMoveManager() : JGManager(CATEGORY_MATEMOVE)
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGMateMoveManager::JGMateMoveManager");
}

//-----------------------------------------------------------------------------
JGMateMoveManager::~JGMateMoveManager()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "JGMateMoveManager::~JGMateMoveManager");

}

//-----------------------------------------------------------------------------
// Return own.
//-----------------------------------------------------------------------------
JGMateMoveManager * JGMateMoveManager::instance()
{
    TRACE_FUNCTION(TRL_LOW, "JGMateMoveManager::instance");
    if (_manager == NULL)
    {
        _manager = new JGMateMoveManager;
    }
    return _manager;
}

//-----------------------------------------------------------------------------
// Initialize
//-----------------------------------------------------------------------------
int JGMateMoveManager::init(void * parm)
{
    TRACE_FUNCTION(TRL_MIDDLE, "JGMateMoveManager::init");
    ACE_UNUSED_ARG(parm);

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Accept trigger from the variable.
//-----------------------------------------------------------------------------
int JGMateMoveManager::notify(const string& category, JGVariable * var,
                              void * arg)
{
    TRACE_FUNCTION(TRL_LOW, "JGMateMoveManager::notify");

    // TRACE_ERROR((_TX("%s : %s = %s\n"), category.c_str(), var->charName(),
    //                                     var->getv().toString().c_str()));

    int result;
    if (category == TRG_MATERIAL_OCCUPIED || category == TRG_MATERIAL_UNOCCUPIED)
    {
        JGDeviceRequest * devReq = new JGDeviceRequest(category, var, arg, this);
        result = this->put(devReq);
    }
    else
    {
        result = BEE_ERROR;
    }
    return result;
}


//-----------------------------------------------------------------------------
// Thread of received trigger event.
//-----------------------------------------------------------------------------
BS2Message * JGMateMoveManager::msg_svc(JGMessageTrigger * trigger,
                                        BS2Message * msg)
{
    ACE_UNUSED_ARG(trigger);
    ACE_UNUSED_ARG(msg);
    BS2Message * replymsg = 0;

    // nop

    return replymsg;
}

//-----------------------------------------------------------------------------
// Thread of received message .
//-----------------------------------------------------------------------------
int JGMateMoveManager::device_svc(JGDeviceTrigger * trigger)
{
    JGDeviceTrigger * notify = trigger;
    if (notify->name() == TRG_MATERIAL_OCCUPIED ||
        notify->name() == TRG_MATERIAL_UNOCCUPIED)
    {
        JGVariable * var = notify->variable();
        m_equipment->sendEvent(this, EVT_MATERIAL_MOVE, var);
    }
    else
    {
        ACE_ERROR((LM_ERROR,
                  ACE_TEXT("(%t) %s manager is not support notification (%s).\n"),
                  this->name().c_str(), notify->name().c_str()));
    }

    return BEE_SUCCESS;
}


