// $Id: JGAlarm.cpp,v 1.4 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGAlarm.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JGAlarm.h"
#include "JGVariable.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"

//-----------------------------------------------------------------------------
// Create alarm data.
//-----------------------------------------------------------------------------
BS2Item * JGAlarm::alarm()
{
    TRACE_FUNCTION(TRL_LOW, "JGAlarm::alarm");
    BS2ListItem * listitem = new BS2ListItem();
    BS2Item * item;
    BYTE alcd = (BYTE)(m_alcd & 0x7F);
    if (m_almstatus)
    {
        alcd |= ALARM_SET;
    }

    item = BS2Item::factory(_TX("ALCD"), new BS2Binary(alcd));
    listitem->add(item);

    item = BS2Item::factory(_TX("ALID"), new BS2UInt4(m_id.getUInt()));
    listitem->add(item);

    item = BS2Item::factory(_TX("ALTX"), new BS2Ascii(m_altx));
    listitem->add(item);

    return listitem;
}

//-----------------------------------------------------------------------------
// Create alarm data.
//-----------------------------------------------------------------------------
BS2Item * JGAlarm::aled()
{
    TRACE_FUNCTION(TRL_LOW, "JGAlarm::aled");
    BS2ListItem * listitem = new BS2ListItem();
    BS2Item * item;
    BYTE aled = 0;
    if (m_enabled)
        aled |= ALARM_ENABLED;

    item = BS2Item::factory(_TX("ALED"), new BS2Binary(aled));
    listitem->add(item);

    item = BS2Item::factory(_TX("ALID"), m_id);
    listitem->add(item);

    return listitem;
}

//-----------------------------------------------------------------------------
// Check variable has been chenged or not.
//-----------------------------------------------------------------------------
bool JGAlarm::changed()
{
    TRACE_FUNCTION(TRL_LOW, "JGAlarm::changed");

    bool result;
    if (m_var != NULL && m_var->changed())
        result = true;
    else
        result = false;

    return result;
}

//-----------------------------------------------------------------------------
// Get Alarm dected or cleard.
//-----------------------------------------------------------------------------
bool JGAlarm::value()
{
    TRACE_FUNCTION(TRL_LOW, "JGAlarm::value");

    bool result = (m_var->getv().isNil() == false);
    return result;
}


//-----------------------------------------------------------------------------
// Print items of the alarm
//-----------------------------------------------------------------------------
void JGAlarm::printOn(string& buf, int mode)
{
    TRACE_FUNCTION(TRL_LOW, "JGAlarm::printOn");
    ACE_UNUSED_ARG(mode);

    m_id.get(buf);
    buf += _TX(" \"");
    buf += m_altx;
    buf += _TX("\" ");
    buf += (m_enabled) ? _TX("true") : _TX("false");
    buf += " ";
    buf += (m_almstatus) ? _TX("set") : _TX("clear");

    return ;
}

