// $Id: JGFileManager.cpp,v 1.2 2003/02/09 16:17:47 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGFileManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "b_ace.h"
#include "JGFileManager.h"
#include "JGFile.h"
#include "JGLogTime.h"

//-----------------------------------------------------------------------------
//
// File Manager
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Initialize
//-----------------------------------------------------------------------------
int JGFileManager::init(const BCHAR ** categories, const string& key)
{
    TRACE_FUNCTION(TRL_LOW, "JGFileManager::init");

    const BCHAR ** cateptr = categories;
    while (*cateptr != NULL)
    {
        // file making
        string category = *cateptr;

        JGFile * file = create(category, key);
        if (file == NULL)
        {
            cateptr++;
            continue;
        }
        //
        m_files.insert(JGFilePair(category, file));
        cateptr++;
    }
    return 0;
}

//-----------------------------------------------------------------------------
// Chage file when begin date.
//-----------------------------------------------------------------------------
int JGFileManager::change(const string& key)
{
    // TRACE_FUNCTION(TRL_LOW, "JGFileManager::change");

    JGFileMap::iterator iter = m_files.begin();
    for ( ; iter != m_files.end(); iter++)
    {
        JGFile * theFile = (*iter).second;
        string category = (*iter).first;

        JGFile * file = create(category, key);
        if (file != NULL)
        {
            delete theFile;
            (*iter).second = file;
        }
        else
        {
            ;    // use the old file
        }
    }
    return 0;
}


//-----------------------------------------------------------------------------
// Find text file
//-----------------------------------------------------------------------------
JGFile * JGFileManager::find(const string& category)
{
    TRACE_FUNCTION(TRL_LOW, "JGFileManager::find");
    JGFileMap::iterator iter = m_files.find(category);
    if (iter == m_files.end())
    {
        return NULL;
    }
    JGFile * result = (*iter).second;
    return result;
}

//-----------------------------------------------------------------------------
// Create new file
//-----------------------------------------------------------------------------
JGFile * JGFileManager::create(const string& category, const string& key)
{
    TRACE_FUNCTION(TRL_LOW, "JGFileManager::create");

    // path=/${rootPath}/${category}/${category}-${key}.${ext}
    string dir = m_rootPath;
    dir.append(DIR_SEPARATOR_STRING);
    dir.append(category);
    string fname = category;
    fname.append(_TX("-"));
    fname.append(key);

    JGFile * file = new JGFile(dir, fname, m_ext);
    int mode = (m_append) ? O_APPEND : 0;
    int result = file->open(mode);
    if (result < 0)
    {
        delete file;
        return NULL;
    }

    return file;
}

//-----------------------------------------------------------------------------
// Erase plane file
//-----------------------------------------------------------------------------
int JGFileManager::close()
{
    TRACE_FUNCTION(TRL_LOW, "JGFileManager::close");

    JGFileMap::iterator iter = m_files.begin();
    for ( ; iter == m_files.end(); iter++)
    {
        JGFile * theFile = (*iter).second;
        if (m_remove)
        {
            theFile->remove();
        }
        else
        {
            theFile->close();
        }
        delete theFile;
    }
    m_files.clear();
    return 0;
}

//-----------------------------------------------------------------------------
int JGFileManager::close(const string& category)
{
    TRACE_FUNCTION(TRL_LOW, "JGFileManager::close");

    JGFileMap::iterator iter = m_files.find(category);
    if (iter == m_files.end())
    {
        return -1;
    }

    JGFile * theFile = (*iter).second;
    if (m_remove)
    {
        theFile->remove();
    }
    else
    {
        theFile->close();
    }
    delete theFile;
    m_files.erase(iter);
    return 0;
}

//-----------------------------------------------------------------------------
// Write Log data to file
//-----------------------------------------------------------------------------
int JGFileManager::write(const string& category, const string& text)
{
    TRACE_FUNCTION(TRL_LOW, "JGFileManager::write");

    JGFile * theFile = find(category);
    if (theFile == NULL)
    {
        TRACE_ERROR((_TX("Can't find file by category"), category.c_str()));
        return -1;
    }
    return theFile->write(text);
}

//-----------------------------------------------------------------------------
int JGFileManager::write(const string& category, const JGLogTime& logtime,
                         const string& text)
{
    TRACE_FUNCTION(TRL_LOW, "JGFileManager::write");

    JGFile * theFile = find(category);
    if (theFile == NULL)
    {
        TRACE_ERROR((_TX("Can't find file by category"), category.c_str()));
        return -1;
    }
    string logtext = const_cast<JGLogTime&>(logtime).toString();
    logtext.append(_TX("  "));
    return theFile->write(text);
}
