/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.secs;

import java.math.BigInteger;

public final class ULong
extends Number
implements Comparable {
    public static final BigInteger MIN_VALUE = new BigInteger("0");
    public static final BigInteger MAX_VALUE = new BigInteger("18446744073709551615");
    private BigInteger value;

    public ULong(BigInteger bigInteger) {
        this.value = bigInteger;
    }

    public ULong(ULong uLong) {
        this.value = uLong.value;
    }

    public ULong(long l) {
        this.value = BigInteger.valueOf(l);
    }

    public ULong(int n) {
        this.value = BigInteger.valueOf(n);
    }

    public ULong(String string) throws NumberFormatException {
        this.value = new BigInteger(string);
        if (this.value.compareTo(MIN_VALUE) < 0 || this.value.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
    }

    public static String toString(int n) {
        BigInteger bigInteger = BigInteger.valueOf(n);
        return bigInteger.toString();
    }

    public static BigInteger parseULong(String string) throws NumberFormatException {
        return ULong.parseULong(string, 16);
    }

    public static BigInteger parseULong(String string, int n) throws NumberFormatException {
        BigInteger bigInteger = new BigInteger(string, n);
        if (bigInteger.compareTo(MIN_VALUE) < 0 || bigInteger.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
        return bigInteger;
    }

    public static ULong valueOf(String string, int n) throws NumberFormatException {
        return new ULong(ULong.parseULong(string, n));
    }

    public static ULong valueOf(String string) throws NumberFormatException {
        return ULong.valueOf(string, 10);
    }

    public static ULong decode(String string) throws NumberFormatException {
        ULong uLong;
        int n = 10;
        int n2 = 0;
        boolean bl = false;
        if (string.startsWith("-")) {
            throw new NumberFormatException("Can't sign.");
        }
        if (string.startsWith("0x", n2) || string.startsWith("0X", n2)) {
            n2 += 2;
            n = 16;
        } else if (string.startsWith("#", n2)) {
            ++n2;
            n = 16;
        } else if (string.startsWith("0", n2) && string.length() > n2 + 1) {
            ++n2;
            n = 8;
        }
        if (string.startsWith("-", n2)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            uLong = ULong.valueOf(string.substring(n2), n);
            uLong = bl ? new ULong(-uLong.intValue()) : uLong;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = "";
            if (bl) {
                string2 = "-";
            }
            string2 = string2 + string.substring(n2);
            uLong = ULong.valueOf(string2, n);
        }
        return uLong;
    }

    public short shortValue() {
        return this.value.shortValue();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object object) {
        try {
            ULong uLong = (ULong)object;
            return uLong.value.equals(this.value);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int compareTo(ULong uLong) {
        return this.value.compareTo(uLong);
    }

    public int compareTo(Object object) {
        return this.value.compareTo(((ULong)object).value);
    }
}

