/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.secs;

import com.jyugem.secs.SECS2XML;
import com.jyugem.secs.SECSDriver;
import com.jyugem.secs.SECSItem;
import com.jyugem.secs.SECSList;
import com.jyugem.secs.SECSParser;
import javax.swing.tree.DefaultMutableTreeNode;

public class SECSMessage
extends DefaultMutableTreeNode {
    protected int m_stnum = 0;
    protected String m_stname;
    protected boolean m_wait = false;
    protected int m_transactionNum = 0;

    public SECSMessage(int n) {
        this.m_stnum = n;
        this.m_stname = SECSMessage.toStreamName(n);
        if ((this.m_stnum & 1) == 1) {
            this.m_wait = true;
        }
    }

    public SECSMessage(String string) {
        this.m_stname = string;
        this.m_stnum = SECSMessage.toStreamNumber(string);
        if ((this.m_stnum & 1) == 1) {
            this.m_wait = true;
        }
    }

    public SECSMessage(String string, boolean bl, int n) {
        this.m_stname = string;
        this.m_stnum = SECSMessage.toStreamNumber(string);
        this.m_wait = bl;
        this.m_transactionNum = n;
    }

    public String toString() {
        return this.m_stname;
    }

    public String name() {
        return this.m_stname;
    }

    public int number() {
        return this.m_stnum;
    }

    public int transaction() {
        return this.m_transactionNum;
    }

    public void transaction(int n) {
        this.m_transactionNum = n;
    }

    public boolean needReply() {
        return this.m_wait;
    }

    public boolean isPrimary() {
        return (this.m_stnum & 1) == 1;
    }

    public static String toStreamName(int n) {
        String string = "S" + Integer.toString(n / 256) + "F" + Integer.toString(n % 256);
        return string;
    }

    public static int toStreamNumber(String string) {
        int n = string.indexOf(83);
        int n2 = string.indexOf(70, n);
        int n3 = string.indexOf(95, n2);
        String string2 = string.substring(n + 1, n2);
        String string3 = n3 > 0 ? string.substring(n2 + 1, n3) : string.substring(n2 + 1);
        int n4 = Integer.parseInt(string2) * 256 + Integer.parseInt(string3);
        return n4;
    }

    public void set(SECSItem sECSItem) {
        this.setUserObject(sECSItem);
        this.setAllowsChildren(false);
    }

    public void set(SECSList sECSList) {
        this.add(sECSList);
    }

    public int traverse(SECSParser sECSParser) {
        sECSParser.set(this);
        if (!this.getAllowsChildren()) {
            SECSItem sECSItem = (SECSItem)this.getUserObject();
            if (sECSItem != null) {
                return sECSItem.parseItem(1, sECSParser);
            }
        } else if (this.getRoot() != null && !this.getRoot().isLeaf()) {
            SECSList sECSList = (SECSList)this.getRoot().getChildAt(0);
            return sECSList.parseItem(1, sECSParser);
        }
        return 0;
    }

    public SECSMessage makeResponse() {
        SECSMessage sECSMessage = new SECSMessage(SECSMessage.toStreamName(this.m_stnum + 1), false, this.m_transactionNum);
        return sECSMessage;
    }

    public String toXMLString() {
        SECS2XML sECS2XML = new SECS2XML();
        int n = this.traverse(sECS2XML);
        if (n >= 0) {
            String string = sECS2XML.toString();
            return string;
        }
        return null;
    }

    public void dump() {
        String string = "\" ";
        if (this.m_wait) {
            string = "\" wait=\"TRUE\" ";
        }
        System.out.println("<secs:message sf=\"" + this.m_stname + string + "transaction=\"" + this.m_transactionNum + "\">");
        if (this.getUserObject() != null) {
            SECSItem sECSItem = (SECSItem)this.getUserObject();
            sECSItem.dump(1);
        } else if (this.getChildCount() > 0) {
            SECSList sECSList = (SECSList)this.getChildAt(0);
            sECSList.dump(1);
        }
        System.out.println("</secs:message>");
    }

    public static void main(String[] stringArray) {
        boolean bl = true;
        SECSMessage sECSMessage = new SECSMessage("S1F1");
        sECSMessage.dump();
        SECSMessage sECSMessage2 = new SECSMessage("S1F2");
        SECSItem sECSItem = new SECSItem("MDLN", "JYUGEM");
        SECSItem sECSItem2 = new SECSItem("SOFTREV", "1.0.0");
        SECSList sECSList = new SECSList();
        sECSList.add(sECSItem);
        sECSList.add(sECSItem2);
        sECSMessage2.set(sECSList);
        sECSMessage2.dump();
        SECSMessage sECSMessage3 = new SECSMessage("S1F14");
        SECSList sECSList2 = new SECSList();
        byte by = 0;
        SECSItem sECSItem3 = new SECSItem("COMMACK", by);
        sECSList2.add(sECSItem3);
        sECSList2.add(sECSList);
        sECSMessage3.set(sECSList2);
        sECSMessage3.dump();
        if (bl) {
            SECSDriver sECSDriver = new SECSDriver();
            sECSDriver.open("secs.xml", 1);
            while (true) {
                SECSMessage sECSMessage4;
                SECSMessage sECSMessage5 = sECSDriver.receive();
                sECSMessage5.dump();
                if (sECSMessage5.name().equals("S1F1")) {
                    sECSMessage4 = sECSMessage5.makeResponse();
                    sECSMessage4.set(sECSList);
                    sECSMessage4.dump();
                    sECSDriver.send(sECSMessage4);
                    continue;
                }
                sECSMessage4 = sECSMessage5.makeResponse();
                sECSMessage4.dump();
                sECSDriver.send(sECSMessage4);
            }
        }
    }
}

