/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.secs;

import com.jyugem.secs.Int1;
import com.jyugem.secs.Jis;
import com.jyugem.secs.SECS;
import com.jyugem.secs.SECSException;
import com.jyugem.secs.SECSParser;
import com.jyugem.secs.UInt1;
import com.jyugem.secs.UInteger;
import com.jyugem.secs.ULong;
import com.jyugem.secs.UShort;
import com.jyugem.secs.Unicode;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class SECSItem {
    public Object m_value = null;
    public String m_name;
    public int m_type;
    static String[] hexTable = new String[]{"0x00", "0x01", "0x02", "0x03", "0x04", "0x05", "0x06", "0x07", "0x08", "0x09", "0x0A", "0x0B", "0x0C", "0x0D", "0x0E", "0x0F", "0x10", "0x11", "0x12", "0x13", "0x14", "0x15", "0x16", "0x17", "0x18", "0x19", "0x1A", "0x1B", "0x1C", "0x1D", "0x1E", "0x1F", "0x20", "0x21", "0x22", "0x23", "0x24", "0x25", "0x26", "0x27", "0x28", "0x29", "0x2A", "0x2B", "0x2C", "0x2D", "0x2E", "0x2F", "0x30", "0x31", "0x32", "0x33", "0x34", "0x35", "0x36", "0x37", "0x38", "0x39", "0x3A", "0x3B", "0x3C", "0x3D", "0x3E", "0x3F", "0x40", "0x41", "0x42", "0x43", "0x44", "0x45", "0x46", "0x47", "0x48", "0x49", "0x4A", "0x4B", "0x4C", "0x4D", "0x4E", "0x4F", "0x50", "0x51", "0x52", "0x53", "0x54", "0x55", "0x56", "0x57", "0x58", "0x59", "0x5A", "0x5B", "0x5C", "0x5D", "0x5E", "0x5F", "0x60", "0x61", "0x62", "0x63", "0x64", "0x65", "0x66", "0x67", "0x68", "0x69", "0x6A", "0x6B", "0x6C", "0x6D", "0x6E", "0x6F", "0x70", "0x71", "0x72", "0x73", "0x74", "0x75", "0x76", "0x77", "0x78", "0x79", "0x7A", "0x7B", "0x7C", "0x7D", "0x7E", "0x7F", "0x80", "0x81", "0x82", "0x83", "0x84", "0x85", "0x86", "0x87", "0x88", "0x89", "0x8A", "0x8B", "0x8C", "0x8D", "0x8E", "0x8F", "0x90", "0x91", "0x92", "0x93", "0x94", "0x95", "0x96", "0x97", "0x98", "0x99", "0x9A", "0x9B", "0x9C", "0x9D", "0x9E", "0x9F", "0xA0", "0xA1", "0xA2", "0xA3", "0xA4", "0xA5", "0xA6", "0xA7", "0xA8", "0xA9", "0xAA", "0xAB", "0xAC", "0xAD", "0xAE", "0xAF", "0xB0", "0xB1", "0xB2", "0xB3", "0xB4", "0xB5", "0xB6", "0xB7", "0xB8", "0xB9", "0xBA", "0xBB", "0xBC", "0xBD", "0xBE", "0xBF", "0xC0", "0xC1", "0xC2", "0xC3", "0xC4", "0xC5", "0xC6", "0xC7", "0xC8", "0xC9", "0xCA", "0xCB", "0xCC", "0xCD", "0xCE", "0xCF", "0xD0", "0xD1", "0xD2", "0xD3", "0xD4", "0xD5", "0xD6", "0xD7", "0xD8", "0xD9", "0xDA", "0xDB", "0xDC", "0xDD", "0xDE", "0xDF", "0xE0", "0xE1", "0xE2", "0xE3", "0xE4", "0xE5", "0xE6", "0xE7", "0xE8", "0xE9", "0xEA", "0xEB", "0xEC", "0xED", "0xEE", "0xEF", "0xF0", "0xF1", "0xF2", "0xF3", "0xF4", "0xF5", "0xF6", "0xF7", "0xF8", "0xF9", "0xFA", "0xFB", "0xFC", "0xFD", "0xFE", "0xFF"};

    public SECSItem(String string, int n, Object object) {
        this.m_name = string;
        this.m_type = n;
        this.m_value = object;
    }

    public SECSItem(String string, String string2) {
        this.m_name = string;
        this.m_value = string2;
        this.m_type = 16;
    }

    public SECSItem(String string, Jis jis) {
        this.m_name = string;
        this.m_value = new Jis(jis);
        this.m_type = 17;
    }

    public SECSItem(String string, Unicode unicode) {
        this.m_name = string;
        this.m_value = new Unicode(unicode);
        this.m_type = 18;
    }

    public SECSItem(String string, byte by) {
        this.m_name = string;
        Byte[] byteArray = new Byte[]{new Byte(by)};
        this.m_value = byteArray;
        this.m_type = 8;
    }

    public SECSItem(String string, byte[] byArray) {
        this.m_name = string;
        this.m_value = byArray;
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = new Byte(byArray[i]);
        }
        this.m_value = byteArray;
        this.m_type = 8;
    }

    public SECSItem(String string, short s) {
        this.m_name = string;
        this.m_value = new Short(s);
        this.m_type = 26;
    }

    public SECSItem(String string, int n) {
        this.m_name = string;
        this.m_value = new Integer(n);
        this.m_type = 28;
    }

    public SECSItem(String string, long l) {
        this.m_name = string;
        this.m_value = new Long(l);
        this.m_type = 24;
    }

    public SECSItem(String string, float f) {
        this.m_name = string;
        this.m_value = new Float(f);
        this.m_type = 36;
    }

    public SECSItem(String string, double d) {
        this.m_name = string;
        this.m_value = new Double(d);
        this.m_type = 32;
    }

    public SECSItem(String string, boolean bl) {
        this.m_name = string;
        this.m_value = new Boolean(bl);
        this.m_type = 9;
    }

    public SECSItem(String string, Int1 int1) {
        this.m_name = string;
        this.m_value = new Int1(int1);
        this.m_type = 25;
    }

    public SECSItem(String string, UInt1 uInt1) {
        this.m_name = string;
        this.m_value = new UInt1(uInt1);
        this.m_type = 41;
    }

    public SECSItem(String string, UShort uShort) {
        this.m_name = string;
        this.m_value = new UShort(uShort);
        this.m_type = 42;
    }

    public SECSItem(String string, UInteger uInteger) {
        this.m_name = string;
        this.m_value = new UInteger(uInteger);
        this.m_type = 44;
    }

    public SECSItem(String string, ULong uLong) {
        this.m_name = string;
        this.m_value = new ULong(uLong);
        this.m_type = 40;
    }

    public SECSItem(String string, short[] sArray) {
        this.m_name = string;
        Short[] shortArray = new Short[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            shortArray[i] = new Short(sArray[i]);
        }
        this.m_value = shortArray;
        this.m_type = 90;
    }

    public SECSItem(String string, int[] nArray) {
        this.m_name = string;
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = new Integer(nArray[i]);
        }
        this.m_value = integerArray;
        this.m_type = 92;
    }

    public SECSItem(String string, long[] lArray) {
        this.m_name = string;
        Long[] longArray = new Long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            longArray[i] = new Long(lArray[i]);
        }
        this.m_value = longArray;
        this.m_type = 88;
    }

    public SECSItem(String string, float[] fArray) {
        this.m_name = string;
        Float[] floatArray = new Float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            floatArray[i] = new Float(fArray[i]);
        }
        this.m_value = floatArray;
        this.m_type = 100;
    }

    public SECSItem(String string, double[] dArray) {
        this.m_name = string;
        Double[] doubleArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            doubleArray[i] = new Double(dArray[i]);
        }
        this.m_value = doubleArray;
        this.m_type = 96;
    }

    public SECSItem(String string, Int1[] int1Array) {
        this.m_name = string;
        Int1[] int1Array2 = new Int1[int1Array.length];
        for (int i = 0; i < int1Array.length; ++i) {
            int1Array2[i] = new Int1(int1Array[i]);
        }
        this.m_value = int1Array2;
        this.m_type = 89;
    }

    public SECSItem(String string, UInt1[] uInt1Array) {
        this.m_name = string;
        UInt1[] uInt1Array2 = new UInt1[uInt1Array.length];
        for (int i = 0; i < uInt1Array.length; ++i) {
            uInt1Array2[i] = new UInt1(uInt1Array[i]);
        }
        this.m_value = uInt1Array2;
        this.m_type = 105;
    }

    public SECSItem(String string, UShort[] uShortArray) {
        this.m_name = string;
        UShort[] uShortArray2 = new UShort[uShortArray.length];
        for (int i = 0; i < uShortArray.length; ++i) {
            uShortArray2[i] = new UShort(uShortArray[i]);
        }
        this.m_value = uShortArray2;
        this.m_type = 106;
    }

    public SECSItem(String string, UInteger[] uIntegerArray) {
        this.m_name = string;
        UInteger[] uIntegerArray2 = new UInteger[uIntegerArray.length];
        for (int i = 0; i < uIntegerArray.length; ++i) {
            uIntegerArray2[i] = new UInteger(uIntegerArray[i]);
        }
        this.m_value = uIntegerArray2;
        this.m_type = 108;
    }

    public SECSItem(String string, ULong[] uLongArray) {
        this.m_name = string;
        ULong[] uLongArray2 = new ULong[uLongArray.length];
        for (int i = 0; i < uLongArray.length; ++i) {
            uLongArray2[i] = new ULong(uLongArray[i]);
        }
        this.m_value = uLongArray2;
        this.m_type = 104;
    }

    public SECSItem(String string, String string2, String string3) throws SECSException {
        this.m_name = string;
        this.m_type = SECSItem.toType(string2);
        if (this.m_type < 0) {
            throw new SECSException("Not support format." + string2);
        }
        if (this.m_type == 16 || string3 != null && string3.length() > 0) {
            this.m_value = this.parseItemValue(this.m_type, string3);
        }
    }

    public SECSItem(String string, ArrayList arrayList) throws RuntimeException {
        this.m_name = string;
        this.m_type = 0;
        this.m_value = new ArrayList(arrayList);
    }

    public String toString() {
        return "";
    }

    public String name() {
        return this.m_name;
    }

    public int type() {
        return this.m_type;
    }

    public Object value() {
        return this.m_value;
    }

    public String typeName() {
        return SECS.toString(this.m_type);
    }

    Object parseListValue(int n, String string) throws SECSException {
        Object var3_3 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Object object = this.parseOneValue(n, string2);
            arrayList.add(object);
        }
        return arrayList;
    }

    Object parseItemValue(int n, String string) throws SECSException {
        Object object = null;
        object = SECS.parseValueOf(n, string);
        return object;
    }

    Object parseOneValue(int n, String string) throws SECSException {
        Object object;
        try {
            object = SECS.convertValueOf(n, string);
        }
        catch (SECSException sECSException) {
            object = null;
        }
        return object;
    }

    public static int toType(String string) {
        int n = -1;
        try {
            n = SECS.toFormat(string);
        }
        catch (SECSException sECSException) {
            // empty catch block
        }
        return n;
    }

    public int parseItem(int n, SECSParser sECSParser) {
        return sECSParser.callWithItem(this.m_type, this.m_name, this.m_value);
    }

    public String getValueString() {
        return SECS.hexdump("", this.m_value);
    }

    private String hexdump(String string) {
        return SECS.hexdump(string, this.m_value);
    }

    public void dump(int n) {
        String string = new String(new char[n * 2]);
        if (this.m_type == 8) {
            System.out.println(string + "<secs:item name=\"" + this.m_name + "\" type=\"" + this.typeName() + "\">" + this.hexdump(string) + "</secs:item>");
        } else if (this.m_type == 0) {
            System.out.println(string + "<secs:itemlist name=\"" + this.m_name + "\">");
            ArrayList arrayList = (ArrayList)this.m_value;
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    System.out.println(string + "  " + arrayList.get(i).toString());
                }
            }
            System.out.println(string + "</secs:itemlist>");
        } else {
            String string2 = "";
            if (this.m_value != null) {
                if (this.m_type > 64) {
                    Object[] objectArray = (Object[])this.m_value;
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (i > 0) {
                            string2 = string2 + " ";
                        }
                        string2 = string2 + objectArray[i].toString();
                    }
                } else {
                    string2 = this.m_value.toString();
                }
            }
            System.out.println(string + "<secs:item name=\"" + this.m_name + "\" type=\"" + this.typeName() + "\">" + string2 + "</secs:item>");
        }
    }
}

