/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.jsunit.tfw;

import com.jyugem.jsunit.tfw.SECSTestCase;
import com.jyugem.jsunit.tfw.SECSTestManager;
import com.jyugem.jsunit.tfw.SECSTestSuite;
import com.jyugem.jsunit.tfw.TestCaseParser;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestTarget
extends Hashtable {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String CREATE_ENTITY_REF_NODES = "http://apache.org/xml/features/dom/create-entity-ref-nodes";
    protected static final String INCLUDE_IGNORABLE_WHITESPACE = "http://apache.org/xml/features/dom/include-ignorable-whitespace";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = true;
    protected static final boolean DEFAULT_CREATE_ENTITY_REF_NODES = false;
    protected static final boolean DEFAULT_INCLUDE_IGNORABLE_WHITESPACE = true;
    DOMParser m_parser = new DOMParser();
    Document m_xmldoc = null;
    TestSuite m_main;
    HashMap m_testcases;
    String m_testName = null;
    String m_logName = null;
    SECSTestManager m_manager = null;

    public TestTarget() {
    }

    public TestTarget(SECSTestManager sECSTestManager) {
        this.m_manager = sECSTestManager;
    }

    public int open(String string) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = true;
        try {
            this.m_parser.setFeature(NAMESPACES_FEATURE_ID, bl);
            this.m_parser.setFeature(VALIDATION_FEATURE_ID, bl2);
            this.m_parser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, bl3);
            this.m_parser.setFeature(CREATE_ENTITY_REF_NODES, bl4);
            this.m_parser.setFeature(INCLUDE_IGNORABLE_WHITESPACE, bl5);
        }
        catch (SAXException sAXException) {
            System.err.println("warning: Parser does not support feature");
        }
        try {
            this.m_parser.parse(string);
            this.setDocument(this.m_parser.getDocument());
            this.build();
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            Exception exception2 = exception;
            if (exception instanceof SAXException) {
                exception2 = ((SAXException)exception).getException();
            }
            if (exception2 != null) {
                exception2.printStackTrace(System.err);
            }
            exception.printStackTrace(System.err);
        }
        return 0;
    }

    public synchronized void setDocument(Document document) {
        this.m_xmldoc = document;
    }

    public Document getDocument() {
        return this.m_xmldoc;
    }

    public TestSuite suite() {
        return this.m_main;
    }

    private void build() throws SAXException {
        if (this.m_xmldoc == null) {
            return;
        }
        NodeList nodeList = this.m_xmldoc.getChildNodes();
        int n = nodeList != null ? nodeList.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("secs:tests")) continue;
            this.parseTests(node);
        }
    }

    private void parseTests(Node node) throws SAXException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            if (node2.getNodeName().equals("name")) {
                this.m_testName = node2.getNodeValue();
                continue;
            }
            if (!node2.getNodeName().equals("logfile")) continue;
            this.m_logName = node2.getNodeValue();
        }
        if (this.m_logName == null) {
            this.m_logName = new String(this.m_testName + ".log");
        }
        this.m_main = new TestSuite(this.m_testName);
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList != null ? nodeList.getLength() : 0;
        for (int i = 0; i < n2; ++i) {
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1) continue;
            if (node3.getNodeName().equals("secs:test")) {
                this.parseTestElementNode(node3);
                continue;
            }
            if (!node3.getNodeName().equals("secs:sequence")) continue;
            this.parseSequenceNode(node3);
        }
    }

    private void parseTestElementNode(Node node) throws SAXException {
        Object object;
        String string = null;
        String string2 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            object = namedNodeMap.item(i);
            if (object.getNodeName().equals("name")) {
                string = object.getNodeValue();
                continue;
            }
            if (!object.getNodeName().equals("description")) continue;
            string2 = object.getNodeValue();
        }
        if (string == null) {
            throw new SAXException("<secs:test> Undefined test name");
        }
        SECSTestSuite sECSTestSuite = new SECSTestSuite(string, string2);
        object = new TestNode(string, (Object)sECSTestSuite);
        this.put(string, object);
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList != null ? nodeList.getLength() : 0;
        for (int i = 0; i < n2; ++i) {
            TestNode testNode;
            String string3;
            Object object2;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().equals("secs:testsuite")) {
                object2 = this.parseTestSuites(node2);
                if (object2 == null) continue;
                string3 = object2.getName();
                testNode = new TestNode(string3, object2);
                this.put(string3, testNode);
                sECSTestSuite.addTest((Test)object2);
                continue;
            }
            if (!node2.getNodeName().equals("secs:testcase") || (object2 = TestCaseParser.parse(node2)) == null) continue;
            string3 = object2.getName();
            testNode = new TestNode(string3, object2);
            this.put(string3, testNode);
            sECSTestSuite.addTest((Test)object2);
        }
    }

    private void parseSequenceNode(Node node) throws SAXException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList != null ? nodeList.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            TestNode testNode;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals("secs:teststep")) continue;
            String string = null;
            Node node3 = node2.getFirstChild();
            if (node3 != null) {
                if (node3.getNodeType() == 3) {
                    string = node3.getNodeValue();
                } else if (node3.getNodeType() == 1) {
                    string = node3.getNodeValue();
                }
            }
            if ((testNode = (TestNode)this.get(string)) == null) {
                throw new SAXException("<secs:teststep> Not found reference. " + string);
            }
            this.m_main.addTest((Test)testNode.get());
        }
    }

    private SECSTestSuite parseTestSuites(Node node) throws SAXException {
        Object object;
        String string = null;
        String string2 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            object = namedNodeMap.item(i);
            if (object.getNodeName().equals("name")) {
                string = object.getNodeValue();
                continue;
            }
            if (!object.getNodeName().equals("description")) continue;
            string2 = object.getNodeValue();
        }
        if (string == null) {
            throw new SAXException("<secs:testsuite> Undefined test name");
        }
        SECSTestSuite sECSTestSuite = new SECSTestSuite(string, string2);
        object = new TestNode(string, (Object)sECSTestSuite);
        this.put(string, object);
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList != null ? nodeList.getLength() : 0;
        for (int i = 0; i < n2; ++i) {
            SECSTestCase sECSTestCase;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals("secs:testcase") || (sECSTestCase = TestCaseParser.parse(node2)) == null) continue;
            String string3 = sECSTestCase.getName();
            TestNode testNode = new TestNode(string3, (Object)sECSTestCase);
            this.put(string3, testNode);
            sECSTestSuite.addTest((Test)sECSTestCase);
        }
        return sECSTestSuite;
    }

    public void dump() {
        Object object;
        System.out.println("*** TestCase ***");
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            object = (TestNode)enumeration.nextElement();
            ((TestNode)object).dump();
        }
        System.out.println("*** Test sequence ***");
        object = this.m_main.tests();
        while (object.hasMoreElements()) {
            Object e = object.nextElement();
            if (e instanceof TestCase) {
                System.out.println(((TestCase)e).getName());
                continue;
            }
            System.out.println(((TestSuite)e).getName());
        }
    }

    public static void main(String[] stringArray) {
        SECSTestManager sECSTestManager = SECSTestManager.getTestManager();
        sECSTestManager.getTestTarget().dump();
    }

    protected class TestNode {
        String m_name;
        String m_description;
        Object m_test;

        TestNode(String string, Object object) {
            this.m_name = string;
            this.m_test = object;
            if (object instanceof SECSTestCase) {
                SECSTestCase sECSTestCase = (SECSTestCase)((Object)object);
                this.m_description = sECSTestCase.getDescription();
            } else if (object instanceof SECSTestSuite) {
                SECSTestSuite sECSTestSuite = (SECSTestSuite)((Object)object);
                this.m_description = sECSTestSuite.getDescription();
            }
        }

        boolean isTestCase() {
            return this.m_test instanceof TestCase;
        }

        boolean isTestSuite() {
            return this.m_test instanceof TestSuite;
        }

        Object get() {
            return this.m_test;
        }

        public String toString() {
            return this.m_name + "\ufffdF" + this.m_description;
        }

        void dump() {
            if (this.isTestSuite()) {
                TestSuite testSuite = (TestSuite)this.m_test;
                System.out.println("<secs:test name=\"" + testSuite.getName() + "\">");
                Enumeration enumeration = testSuite.tests();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    Object e = enumeration.nextElement();
                    if (e instanceof SECSTestCase) {
                        object = (SECSTestCase)((Object)e);
                        System.out.println(((SECSTestCase)((Object)object)).toXmlString());
                        continue;
                    }
                    if (e instanceof SECSTestSuite) {
                        object = (SECSTestSuite)((Object)e);
                        System.out.println(((SECSTestSuite)((Object)object)).toXmlString());
                        continue;
                    }
                    System.out.println("UNKNOWN: " + e.getClass().getName());
                }
                System.out.println("</secs:test>\n");
            }
        }
    }
}

