/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.jsunit.tfw;

import com.jyugem.jsunit.tfw.SECSTestAssert;
import com.jyugem.jsunit.tfw.SECSTestManager;
import com.jyugem.jsunit.tfw.TestPair;
import com.jyugem.secs.MessageBox;
import com.jyugem.secs.SECSMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.w3c.dom.Node;

public abstract class SECSTestCase
extends SECSTestAssert {
    protected static String m_resent;
    protected static MessageBox m_msgbox;
    protected SECSTestManager m_manager = null;
    protected String m_methodName;
    protected int m_delay = -1;
    protected int m_sleep = -1;
    protected String m_description;
    protected TestPair m_pair;

    public SECSTestCase(String string) {
        super(string);
    }

    public static String getResentReceived() {
        return m_resent;
    }

    public void setManager(SECSTestManager sECSTestManager) {
        this.m_manager = sECSTestManager;
        m_msgbox = this.m_manager.messageBox();
        this.m_pair.setManager(this.m_manager);
    }

    protected void setUp() {
    }

    protected void runTest() throws Throwable {
        Method method = null;
        try {
            method = ((Object)((Object)this)).getClass().getMethod(this.m_methodName, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            SECSTestCase.fail((String)("Method \"" + this.m_methodName + "\" not found"));
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            SECSTestCase.fail((String)("Method \"" + this.m_methodName + "\" should be public"));
        }
        try {
            method.invoke((Object)this, (Object[])new Class[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.fillInStackTrace();
            throw invocationTargetException.getTargetException();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.fillInStackTrace();
            throw illegalAccessException;
        }
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String string) {
        this.m_description = string;
    }

    public void setWatchTime(int n) {
        this.m_delay = n;
    }

    public void setSleepTime(int n) {
        this.m_sleep = n;
    }

    public void newPair() {
        this.m_pair.init();
    }

    public abstract void addPair(String var1, Node var2);

    public abstract void addPair(String var1, boolean var2);

    public void setLast(String string, int n, int n2, int n3) {
        this.m_pair.setLast(string, n, n2, n3);
    }

    public void replyNormal(SECSMessage sECSMessage) {
        this.m_manager.send(sECSMessage);
        SECSMessage sECSMessage2 = m_msgbox.get(this.m_delay);
        SECSTestCase.assertNull((Object)sECSMessage2);
    }

    public Object getItemValue(SECSMessage sECSMessage, String string, String string2) {
        if (!string.equals(sECSMessage.name())) {
            return null;
        }
        SECSTestAssert.ItemGetter itemGetter = new SECSTestAssert.ItemGetter(string2);
        sECSMessage.traverse(itemGetter);
        Object object = itemGetter.getValue();
        return object;
    }

    public Object getItemValue(SECSMessage sECSMessage, String string, String string2, int n) {
        if (!string.equals(sECSMessage.name())) {
            return null;
        }
        SECSTestAssert.ItemGetter itemGetter = new SECSTestAssert.ItemGetter(string2, n);
        sECSMessage.traverse(itemGetter);
        Object object = itemGetter.getValue();
        return object;
    }

    public String toXmlString(boolean bl) {
        String string = "<secs:testcase name=\"" + this.getName() + "\" description=\"" + this.m_description + "\"";
        string = this.m_delay > 0 ? string + " time=\"" + this.m_delay + "\">\n" : string + ">\n";
        string = string + this.m_pair.toXmlString(bl);
        string = string + "</secs:testcase>";
        return string;
    }

    public String toXmlString() {
        return this.toXmlString(this.m_methodName.indexOf("Active") > 0);
    }

    public String toString() {
        return this.getName() + " : " + this.m_description;
    }
}

