/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.jsunit.tfw;

import com.jyugem.jsunit.tfw.TestPair;
import com.jyugem.secs.SECSMessage;
import com.jyugem.secs.SECSParser;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Pattern;

public class SECSTestAssert
extends TestCase {
    public static int PASS = 0;
    public static int XPASS = 1;
    public static int FAIL = 2;
    public static int XFAIL = 3;
    public static int UNRESOLVED = 4;
    public static int UNSUPPORTED = 5;
    public static int UNTESTED = 6;
    public static int ERROR = -1;
    public static int WARNING = -2;
    protected Perl5Compiler m_compiler = new Perl5Compiler();
    protected Perl5Matcher m_matcher = new Perl5Matcher();
    protected Pattern m_pattern;

    public SECSTestAssert(String string) {
        super(string);
        this.m_matcher.setMultiline(true);
    }

    public static void pass(String string) {
        System.out.println("PASS: " + string);
    }

    public static void fail(String string, String string2) {
        SECSTestAssert.throwError("FAIL: ", null, string, string2);
    }

    public static void fail(String string, String string2, String string3) {
        SECSTestAssert.throwError("FAIL: ", string, string2, string3);
    }

    public static void xfail(String string, String string2) {
        SECSTestAssert.throwError("XFAIL: ", null, string, string2);
    }

    public static void xfail(String string, String string2, String string3) {
        SECSTestAssert.throwError("XFAIL: ", string, string2, string3);
    }

    public static void unresolved(String string, String string2) {
        SECSTestAssert.throwError("UNRESOLVED: ", null, string, string2);
    }

    public static void unresolved(String string, String string2, String string3) {
        SECSTestAssert.throwError("UNRESOLVED: ", string, string2, string3);
    }

    public static void unsupported(String string, String string2) {
        SECSTestAssert.throwError("UNSUPPORTED: ", null, string, string2);
    }

    public static void unsupported(String string, String string2, String string3) {
        SECSTestAssert.throwError("UNSUPPORTED: ", string, string2, string3);
    }

    public static void warning(String string, String string2) {
        SECSTestAssert.throwError("WARNING: ", null, string, string2);
    }

    public static void warning(String string, String string2, String string3) {
        SECSTestAssert.throwError("WARNING: ", string, string2, string3);
    }

    public static void error(String string, String string2) {
        SECSTestAssert.throwError("ERROR: ", null, string, string2);
    }

    public static void error(String string, String string2, String string3) {
        SECSTestAssert.throwError("ERROR: ", string, string2, string3);
    }

    private static void throwError(String string, String string2, String string3, String string4) {
        String string5 = "\n### [" + string + "] ";
        if (string2 != null) {
            string5 = string5 + string2;
        }
        string5 = string5 + "\n### expected ###\n" + string3 + "\n### but was  ###\n" + string4 + "\n";
        throw new AssertionFailedError(string5);
    }

    public void assertMatch(String string, SECSMessage sECSMessage) {
        this.assertMatch(null, string, sECSMessage, TestPair.MATCH);
    }

    public void assertMatch(String string, String string2, SECSMessage sECSMessage) {
        this.assertMatch(string, string2, sECSMessage, TestPair.MATCH);
    }

    public void assertMatch(String string, SECSMessage sECSMessage, int n) {
        this.assertMatch(null, string, sECSMessage, n);
    }

    public void assertMatch(String string, String string2, SECSMessage sECSMessage, int n) {
        this.m_compiler = new Perl5Compiler();
        this.m_matcher = new Perl5Matcher();
        if (string2 == null && sECSMessage == null) {
            return;
        }
        String string3 = sECSMessage.toXMLString();
        SECSTestAssert.assertTrue((string3 != null ? 1 : 0) != 0);
        try {
            this.m_pattern = (Perl5Pattern)this.m_compiler.compile(string2, 16);
        }
        catch (MalformedPatternException malformedPatternException) {
            SECSTestAssert.error(string, string2, "Perl5Pattern compile.");
        }
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string3);
        if (n == TestPair.NOT_CONTAIN) {
            if (!this.m_matcher.contains(patternMatcherInput, this.m_pattern)) {
                SECSTestAssert.pass(string);
                return;
            }
            SECSTestAssert.xfail(string, string2, string3);
        } else if (n == TestPair.CONTAIN) {
            if (this.m_matcher.contains(patternMatcherInput, this.m_pattern)) {
                SECSTestAssert.pass(string);
                return;
            }
        } else if (this.m_matcher.matches(patternMatcherInput, this.m_pattern)) {
            SECSTestAssert.pass(string);
            return;
        }
        SECSTestAssert.fail(string, string2, string3);
    }

    public SECSMessage assertMatch(TestPair testPair, SECSMessage sECSMessage) {
        return this.assertMatch(null, testPair, sECSMessage);
    }

    public SECSMessage assertMatch(String string, TestPair testPair, SECSMessage sECSMessage) {
        this.m_compiler = new Perl5Compiler();
        this.m_matcher = new Perl5Matcher();
        if (testPair == null && sECSMessage == null) {
            return null;
        }
        String string2 = sECSMessage.toXMLString();
        SECSTestAssert.assertTrue((string2 != null ? 1 : 0) != 0);
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string2);
        int n = testPair.size();
        for (int i = 0; i < n; ++i) {
            String string3 = testPair.getExpect(i);
            try {
                this.m_pattern = (Perl5Pattern)this.m_compiler.compile(string3, 16);
            }
            catch (MalformedPatternException malformedPatternException) {
                SECSTestAssert.error(string, string3, "Perl5Pattern compile.");
            }
            if (testPair.getMatch() == TestPair.NOT_CONTAIN) {
                if (!this.m_matcher.contains(patternMatcherInput, this.m_pattern)) {
                    SECSTestAssert.pass(string);
                    return testPair.getMessage(i);
                }
                SECSTestAssert.xfail(string, testPair.getExpect(), string2);
                continue;
            }
            if (testPair.getMatch() == TestPair.CONTAIN) {
                if (!this.m_matcher.contains(patternMatcherInput, this.m_pattern)) continue;
                SECSTestAssert.pass(string);
                return testPair.getMessage(i);
            }
            if (testPair.getMatch() == TestPair.NOT_MATCH) {
                if (this.m_matcher.contains(patternMatcherInput, this.m_pattern)) continue;
                SECSTestAssert.pass(string);
                return testPair.getMessage(i);
            }
            if (!this.m_matcher.matches(patternMatcherInput, this.m_pattern)) continue;
            SECSTestAssert.pass(string);
            return testPair.getMessage(i);
        }
        SECSTestAssert.fail(string, testPair.getExpect(), string2);
        return null;
    }

    public SECSMessage compareMatch(TestPair testPair, SECSMessage sECSMessage) {
        return this.assertMatch(null, testPair, sECSMessage);
    }

    public SECSMessage compareMatch(String string, TestPair testPair, SECSMessage sECSMessage) {
        this.m_compiler = new Perl5Compiler();
        this.m_matcher = new Perl5Matcher();
        if (testPair == null && sECSMessage == null) {
            return null;
        }
        String string2 = sECSMessage.toXMLString();
        SECSTestAssert.assertTrue((string2 != null ? 1 : 0) != 0);
        PatternMatcherInput patternMatcherInput = new PatternMatcherInput(string2);
        int n = testPair.size();
        for (int i = 0; i < n; ++i) {
            String string3 = testPair.getExpect(i);
            try {
                this.m_pattern = (Perl5Pattern)this.m_compiler.compile(string3, 16);
            }
            catch (MalformedPatternException malformedPatternException) {
                SECSTestAssert.error(string, string3, "Perl5Pattern compile.");
            }
            if (testPair.getMatch() == TestPair.NOT_CONTAIN) {
                if (!this.m_matcher.contains(patternMatcherInput, this.m_pattern)) {
                    SECSTestAssert.pass(string);
                    return testPair.getMessage(i);
                }
                return null;
            }
            if (testPair.getMatch() == TestPair.CONTAIN) {
                if (!this.m_matcher.contains(patternMatcherInput, this.m_pattern)) continue;
                SECSTestAssert.pass(string);
                return testPair.getMessage(i);
            }
            if (testPair.getMatch() == TestPair.NOT_MATCH) {
                if (this.m_matcher.contains(patternMatcherInput, this.m_pattern)) continue;
                SECSTestAssert.pass(string);
                return testPair.getMessage(i);
            }
            if (!this.m_matcher.matches(patternMatcherInput, this.m_pattern)) continue;
            SECSTestAssert.pass(string);
            return testPair.getMessage(i);
        }
        return null;
    }

    public void assertAck(String string, String string2, SECSMessage sECSMessage) {
        this.assertAckCode(null, string, string2, sECSMessage, 0);
    }

    public void assertAck(String string, String string2, String string3, SECSMessage sECSMessage) {
        this.assertAckCode(string, string2, string3, sECSMessage, 0);
    }

    public void assertNack(String string, String string2, SECSMessage sECSMessage) {
        this.assertAckCode(null, string, string2, sECSMessage, 1);
    }

    public void assertNack(String string, String string2, String string3, SECSMessage sECSMessage) {
        this.assertAckCode(string, string2, string3, sECSMessage, 1);
    }

    public void assertAckCode(String string, String string2, String string3, SECSMessage sECSMessage, int n) {
        if (!string2.equals(sECSMessage.name())) {
            SECSTestAssert.fail(string, string2, sECSMessage.name());
        }
        String string4 = n == 0 ? " = 0" : " != 0";
        ItemGetter itemGetter = new ItemGetter(string3);
        sECSMessage.traverse(itemGetter);
        Object object = itemGetter.getValue();
        if (object != null) {
            if (object instanceof Number) {
                int n2 = ((Number)object).intValue();
                if (n == 0 && n2 == 0) {
                    return;
                }
                if (n != 0 && n2 != 0) {
                    return;
                }
            }
            SECSTestAssert.fail(string, string2 + "." + string3 + string4, sECSMessage.name() + "." + string3 + " = " + object.toString() + "\n");
        }
        SECSTestAssert.fail(string, string2 + "." + string3 + string4 + "\n", sECSMessage.name() + "\n");
    }

    protected class ItemGetter
    implements SECSParser {
        String m_iname;
        Object m_result = null;
        int m_type = -1;
        SECSMessage m_message;

        protected ItemGetter(String string) {
            this.m_iname = string;
        }

        protected ItemGetter(String string, int n) {
            this.m_iname = string;
            this.m_type = n;
        }

        protected Object getValue() {
            return this.m_result;
        }

        public void set(SECSMessage sECSMessage) {
            this.m_message = sECSMessage;
        }

        public int callWithItem(int n, String string, Object object) {
            if (this.m_iname.equals(string) && (this.m_type < 0 || this.m_type == n)) {
                this.m_result = object;
                return -1;
            }
            return 0;
        }

        public int beginList(int n, int n2) {
            return 0;
        }

        public int endList(int n) {
            return 0;
        }
    }
}

