/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.jsunit.gui;

import com.jyugem.jsunit.gui.TestRunContext;
import com.jyugem.jsunit.gui.TestRunView;
import com.jyugem.jsunit.gui.TestRunner;
import com.jyugem.jsunit.gui.TestSuitePanel;
import com.jyugem.jsunit.gui.TestTreeModel;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;

public class TestHierarchyRunView
implements TestRunView {
    TestSuitePanel fTreeBrowser;
    TestRunContext fTestContext;

    public TestHierarchyRunView(TestRunContext testRunContext) {
        this.fTestContext = testRunContext;
        this.fTreeBrowser = new TestSuitePanel();
        this.fTreeBrowser.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TestHierarchyRunView.this.testSelected();
            }
        });
    }

    public void addTab(JTabbedPane jTabbedPane) {
        Icon icon = TestRunner.getIconResource(this.getClass(), "icons/hierarchy.gif");
        jTabbedPane.addTab("Test Hierarchy", icon, this.fTreeBrowser, "The test hierarchy");
    }

    public Test getSelectedTest() {
        return this.fTreeBrowser.getSelectedTest();
    }

    public void activate() {
        this.testSelected();
    }

    public void revealFailure(Test test) {
        JTree jTree = this.fTreeBrowser.getTree();
        TestTreeModel testTreeModel = (TestTreeModel)jTree.getModel();
        Vector vector = new Vector();
        int n = testTreeModel.findTest(test, (Test)testTreeModel.getRoot(), vector);
        if (n >= 0) {
            Object[] objectArray = new Object[vector.size() + 1];
            vector.copyInto(objectArray);
            Object object = objectArray[vector.size() - 1];
            objectArray[vector.size()] = testTreeModel.getChild(object, n);
            TreePath treePath = new TreePath(objectArray);
            jTree.setSelectionPath(treePath);
            jTree.makeVisible(treePath);
        }
    }

    public void aboutToStart(Test test, TestResult testResult) {
        this.fTreeBrowser.showTestTree(test);
        testResult.addListener((TestListener)this.fTreeBrowser);
    }

    public void runFinished(Test test, TestResult testResult) {
        testResult.removeListener((TestListener)this.fTreeBrowser);
    }

    protected void testSelected() {
        this.fTestContext.handleTestSelected(this.getSelectedTest());
    }
}

