#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    xls2csv.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================
"""
Copyright (C) 2004 BEE Co.,Ltd. All Rights Reserved.

To use, simply 'import xls2csv'.
"""

import getopt, sys, string, os, shutil
import win32com.client

xlsfiles = { 'gemdb': ["gemdb"],
             'variables': ["variables"],
             'rcmds': ["rcmds", "params"],
             'objtype': ["objtype", "attribute"],
             'config': ["config"],
             'connector': ["connector"],
             'recipe': ["recipe"],
             'iodevice': ["iodevice", "subsystem", "sac"],
             'limits': ["limits"],
             'traces': ["traces", "trace_vars"],
             'trigger': ["trigger"],
             'event': ["event", "evtrpt", "report", "rptdata" ],
             'alarm': ["alarm"] }


#
# Get csv file in excel file
#
def getsheet(com, xlsname, outdir, shlist):
    obj = com.Workbooks.Open(xlsname)
    for sheet in shlist:
        obj.Worksheets(sheet).Activate()
        shfile = "%s%s%s.csv" % (outdir, os.sep, sheet)
        print "SHEET:", shfile
        if os.access(shfile, os.W_OK | os.R_OK):
            cpname = shfile
            cpname += ".bak"
            shutil.move(shfile, cpname)
        obj.SaveAs(shfile, 6)   # 6 is xlCSV
    obj.Close(0)

#
# Get csv file in excel file
#
def jyugem_csv(dirname):
    dirname += os.sep
    outdir = dirname
    dirname += "xlsheets"
    outdir += "csvfiles"
    #
    o = win32com.client.Dispatch("Excel.Application")
    o.Visible = 0
    for xlsname, shlist in xlsfiles.items():
        xlsfile = "%s%s%s.xls" % (dirname, os.sep, xlsname)
        print "EXCEL:", xlsfile
        getsheet(o, xlsfile, outdir, shlist)
    o.Quit()


#
# Print usage of this script
#
def usage():
    print("xls2csv [-d <dirname>] [-o <outdir>] [-h]");


#
# Test main
#
def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "hd:", ["help", "dir="])
    except getopt.GetoptError:
        usage()
        sys.exit(2)

    dirname = os.getcwd()
    for o, a in opts:
        if o in ("-d", "--dir"):
            dirname = a
        if o in ("-h", "--help"):
            usage()
            sys.exit()
    # ...

    jyugem_csv(dirname)


if __name__ == "__main__":
    main()
