#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    g_trace.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os
import csv
import sqlite, pdo

#
# G_EVENT
#
trace_fields = ['TRID','DSPER','TOTSMP','REPGSZ']
target_fields = ['TRID','VID','SEQ_NUM']

_insert_trace = """
insert into g_traces (TRID,DSPER,TOTSMP,REPGSZ,UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s, %s)
"""
_insert_target = """
insert into g_trace_vars (TRID,VID,SEQ_NUM,UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s)
"""

def ins_trace(cn, filename):
    reader = csv.DictReader(file(filename), trace_fields)

    cn.execute("delete from g_traces");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['TRID']) > 0:
            cn.execute(_insert_trace, (row['TRID'],
                                       row['DSPER'],
                                       row['TOTSMP'],
                                       row['REPGSZ'],
                                       "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def ins_target(cn, filename):
    reader = csv.DictReader(file(filename), target_fields)

    cn.execute("delete from g_trace_vars");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['TRID']) > 0:
            cn.execute(_insert_target, (row['TRID'],
                                        row['VID'],
                                        row['SEQ_NUM'],
                                        "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def to_sqlite(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    outfile = dirname + os.sep + output + ".edb"
    cx = sqlite.connect(outfile)
    cn = cx.cursor()
    #
    ins_trace(cn, csvdir + os.sep + "traces.csv")
    ins_target(cn, csvdir + os.sep + "trace_vars.csv")
    #
    cx.commit()
    cx.close()

#
def to_mysql(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    dsn = "Module=MySQLdb;User=%s;Passwd=%s;DB=%s" % ("jyugem", "jyugem", output)
    db = pdo.connect(dsn)
    #
    ins_trace(db, csvdir + os.sep + "traces.csv")
    ins_target(db, csvdir + os.sep + "trace_vars.csv")
    #
    db.close()


#
def usage():
    print("g_trace [-f <dbname>]");


def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "hf:v", ["help", "file="])
    except getopt.GetoptError:
        usage()
        sys.exit(2)
    output = 'gem'
    verbose = False
    for o, a in opts:
        if o == "-v":
            verbose = True
        if o in ("-f", "--file"):
            output = a
        if o in ("-h", "--help"):
            usage()
            sys.exit()
    # ...

    dirname = os.getcwd()
    if not mysql:
        to_sqlite(output, dirname)
    else:
        to_mysql(output, dirname)

if __name__ == "__main__":
    main()

